import { r as registerInstance, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { a as onComponentRequiredPropUndefined, R as getInputHelperTextID, S as getInputValidationTextID, T as warningIcon, U as errorIcon, P as successIcon } from './helpers-3905ccc4.js';
import { a as IcInformationStatus } from './types-6f6b41a5.js';

const icInputLabelCss = "ic-input-label{margin-bottom:var(--ic-space-xs)}ic-input-label.with-helper{margin-bottom:var(--ic-space-xxxs)}ic-input-label.readonly{color:var(--ic-color-tertiary-text)}ic-input-label .helpertext{margin-top:var(--ic-space-xxxs)}ic-input-label .helpertext-normal{color:var(--ic-color-secondary-text)}ic-input-label .helpertext-readonly{color:var(--ic-color-tertiary-text)}ic-input-label .readonly-label{color:var(--ic-color-secondary-text)}ic-input-label .error-label{color:var(--ic-status-error)}ic-input-label .dark{color:var(--ic-architectural-white)}";

const InputLabel = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.appearance = "default";
        this.dark = false;
        this.disabled = false;
        this.error = false;
        this.for = undefined;
        this.helperText = "";
        this.label = undefined;
        this.readonly = false;
        this.required = false;
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Input Label");
    }
    render() {
        const { disabled, readonly, label, required, helperText, error, dark, appearance, } = this;
        const labelText = required ? label + " *" : label;
        const labelContent = readonly ? (`${labelText}`) : (h("label", { htmlFor: this.for }, labelText));
        const id = getInputHelperTextID(this.for);
        return (h(Host, { class: {
                ["disabled"]: disabled,
                ["readonly"]: readonly,
                ["with-helper"]: helperText !== "",
            } }, h("ic-typography", { variant: "label", class: {
                ["readonly-label"]: readonly,
                ["error-label"]: error && !(readonly || disabled),
                ["dark"]: dark || appearance === "dark",
            } }, labelContent), helperText !== "" && (h("ic-typography", { variant: "caption", class: {
                ["helpertext"]: true,
                ["helpertext-normal"]: !disabled && !readonly,
                ["helpertext-readonly"]: readonly,
            } }, h("span", { id: id }, helperText)))));
    }
};
InputLabel.style = icInputLabelCss;

const icInputValidationCss = "ic-input-validation{width:var(--input-width, 20rem);margin-top:var(--ic-space-xs);display:flex}ic-input-validation.fullwidth{width:100%}ic-input-validation span.status-icon{padding-right:var(--ic-space-xxs)}ic-input-validation span.status-icon>svg{height:1.25rem;width:1.25rem}ic-input-validation span.icon-success>svg{fill:var(--ic-status-success)}ic-input-validation span.icon-error>svg{fill:var(--ic-status-error)}ic-input-validation span.icon-warning>svg{fill:var(--ic-status-warning)}ic-input-validation .statustext{flex-grow:1}";

const icon = {
    [IcInformationStatus.Warning]: warningIcon,
    [IcInformationStatus.Error]: errorIcon,
    [IcInformationStatus.Success]: successIcon,
};
const InputValidation = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.ariaLiveMode = "polite";
        this.for = undefined;
        this.fullWidth = false;
        this.message = undefined;
        this.status = "";
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.message, propName: "message" }], "Input Validation");
    }
    render() {
        const displayIcon = this.status !== "" ? icon[this.status] : "";
        const id = getInputValidationTextID(this.for);
        return (h(Host, { class: {
                [this.status]: this.status !== "",
                ["fullwidth"]: this.fullWidth,
            } }, displayIcon !== "" && (h("span", { class: {
                ["status-icon"]: true,
                [`icon-${this.status}`]: true,
            }, innerHTML: displayIcon })), h("ic-typography", { variant: "caption", class: "statustext" }, h("span", { "aria-live": this.ariaLiveMode, id: id }, this.message)), h("slot", { name: "validation-message-adornment" })));
    }
    get el() { return getElement(this); }
};
InputValidation.style = icInputValidationCss;

export { InputLabel as ic_input_label, InputValidation as ic_input_validation };

//# sourceMappingURL=ic-input-label_2.entry.js.map