import { r as registerInstance, f as forceUpdate, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { O as OpenInNew } from './OpenInNew-cdeed5ce.js';
import { y as IC_INHERITED_ARIA, x as inheritAttributes, l as getThemeFromContext } from './helpers-3905ccc4.js';
import { I as IcThemeForegroundEnum } from './types-6f6b41a5.js';

const icLinkCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host(.link) .ic-link,:host(.link) ::slotted(a){color:var(--ic-hyperlink);text-decoration:underline;font-weight:var(--ic-font-weight-bold);transition:var(--ic-easing-transition-fast)}:host(.link.dark) .ic-link.dark,:host(.link.dark) ::slotted(a){color:var(--ic-color-primary-text)}:host(.link.light) .ic-link.light,:host(.link.light) ::slotted(a){color:var(--ic-color-white-text)}:host(.link) .ic-link:visited,:host(.link) ::slotted(a:visited){color:var(--ic-hyperlink-visited)}:host(.link) .ic-link:hover,:host(.link) .ic-link:focus,:host(.link) ::slotted(a:hover),:host(.link) ::slotted(a:focus){outline:none;border-bottom:0.25rem solid !important;margin-bottom:-0.25rem !important;text-decoration:none}@supports (text-underline-offset: 10%){:host(.link) .ic-link:hover,:host(.link) .ic-link:focus,:host(.link) ::slotted(a:hover),:host(.link) ::slotted(a:focus){text-decoration-line:underline;text-decoration-thickness:25%;text-underline-offset:10%;border-bottom:0 !important;margin-bottom:0 !important}}:host(.link) .ic-link:active,:host(.link) .ic-link:focus:active,:host(.link) .ic-link:visited:active,:host(.link) ::slotted(a:active),:host(.link) ::slotted(a:focus:active),:host(.link) ::slotted(a:visited:active){text-decoration:none}.ic-link-open-in-new-icon{vertical-align:middle;margin-left:var(--ic-space-xxs)}.ic-link>.ic-link-open-in-new-icon{fill:var(--ic-hyperlink)}.ic-link.dark>.ic-link-open-in-new-icon{fill:var(--ic-color-primary-text)}.ic-link.light>.ic-link-open-in-new-icon{fill:var(--ic-color-white-text)}.ic-link-open-in-new-icon>svg{width:var(--ic-space-md);height:var(--ic-space-md);fill:currentcolor}.ic-link:visited>.ic-link-open-in-new-icon{fill:var(--ic-hyperlink-visited)}.ic-link.light:visited>.ic-link-open-in-new-icon{fill:var(--ic-hyperlink-contrast-visited)}:host(.breadcrumb-link) .ic-link{display:var(--breadcrumb-link-display);align-items:var(--breadcrumb-link-align-items);gap:var(--breadcrumb-link-gap)}:host(.breadcrumb-link) .ic-link ::slotted(.back-icon){height:var(--ic-space-lg);width:var(--ic-space-lg)}:host(.breadcrumb-link.current-page) a,:host(.breadcrumb-link.current-page) ::slotted(a){font-weight:normal;color:inherit;text-decoration:none;display:flex;align-items:center}:host(.breadcrumb-link.current-page) .ic-link,:host(.breadcrumb-link.current-page) ::slotted(a:focus){outline:var(--ic-hc-focus-outline);text-decoration:none}:host(.breadcrumb-link.current-page) .ic-link:visited{color:var(--ic-color-primary-text)}";

const Link = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.inheritedAttributes = {};
        this.hostMutationObserver = null;
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName }) => {
                if (IC_INHERITED_ARIA.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] =
                        this.el.getAttribute(attributeName);
                    forceComponentUpdate = true;
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.appearance = "default";
        this.download = false;
        this.href = null;
        this.hreflang = undefined;
        this.referrerpolicy = undefined;
        this.rel = undefined;
        this.showIcon = undefined;
        this.target = undefined;
    }
    componentWillLoad() {
        this.inheritedAttributes = inheritAttributes(this.el, IC_INHERITED_ARIA);
        this.updateTheme();
    }
    componentDidLoad() {
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            attributes: true,
        });
    }
    disconnectedCallback() {
        var _a;
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    themeChangeHandler({ detail }) {
        this.updateTheme(detail.mode);
    }
    /**
     * Sets focus on the link.
     */
    async setFocus() {
        var _a;
        (_a = this.el.shadowRoot.querySelector("a")) === null || _a === void 0 ? void 0 : _a.focus();
    }
    updateTheme(newTheme = null) {
        const theme = getThemeFromContext(this.el, newTheme);
        if (theme !== IcThemeForegroundEnum.Default) {
            this.appearance = theme;
        }
    }
    hasRouterSlot() {
        this.routerSlot = this.el.querySelector('[slot="router-item"]');
        if (this.routerSlot) {
            this.routerSlot.ariaLabel = this.routerSlot.textContent;
        }
        return !!this.routerSlot;
    }
    render() {
        const { download, href, hreflang, referrerpolicy, rel, target, showIcon, appearance, } = this;
        return (h(Host, { class: { ["link"]: true, [`${appearance}`]: true } }, this.hasRouterSlot() ? (h("slot", { name: "router-item" })) : (h("a", Object.assign({ class: {
                ["ic-link"]: href !== null,
                [`${appearance}`]: href !== null,
            }, download: download !== false ? download : null, href: href, hrefLang: hreflang, referrerPolicy: referrerpolicy, rel: rel, target: target, tabindex: href !== null ? "0" : "-1" }, this.inheritedAttributes), h("slot", null), (showIcon || target === "_blank") && (h("span", { class: "ic-link-open-in-new-icon", innerHTML: OpenInNew }))))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
};
Link.style = icLinkCss;

export { Link as ic_link };

//# sourceMappingURL=ic-link.entry.js.map