import { r as registerInstance, c as createEvent, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { M as getSlotContent, L as getSlot, i as isSlotUsed } from './helpers-3905ccc4.js';
import './types-6f6b41a5.js';

const icNavigationMenuCss = ":host{display:block;position:fixed;top:0;left:0;width:100%;min-height:100% !important;background:rgb(0 0 0 / 60%);z-index:var(--ic-z-index-navigation-menu)}.popout-modal{position:absolute;inset:0}.popout-menu{position:fixed;top:0;right:0;width:16rem;bottom:0;background-color:var(--ic-architectural-20);color:var(--ic-color-primary-text);box-shadow:var(--ic-elevation-overlay);overflow-y:auto;overflow-x:hidden}:host(.inline) .popout-menu{position:absolute}.menu-close-button-container{position:relative;left:11.875rem;padding:var(--ic-space-md) 0}.nav-group-first{padding-bottom:0}.menu-buttons-container{padding:var(--ic-space-sm) 0;border-bottom:var(--ic-border-width) solid var(--ic-architectural-200)}.menu-buttons-container-nav-item-above{margin-top:var(--ic-space-md);border-top:var(--ic-border-width) solid var(--ic-architectural-200)}.menu-status-version-container{display:flex;flex-wrap:wrap;gap:var(--ic-space-xs);padding:var(--ic-space-md) var(--ic-space-md) var(--ic-space-xl)}.status-version-no-buttons{border-top:var(--ic-space-1px) solid var(--ic-architectural-200)}.menu-status{background-color:var(--ic-architectural-500);color:var(--ic-color-white-text);border-radius:var(--ic-space-md);width:-moz-fit-content;width:fit-content;padding:var(--ic-space-xxs) var(--ic-space-sm)}.menu-version{border-radius:var(--ic-space-md);background-color:var(--ic-architectural-100);padding:var(--ic-space-xxs) var(--ic-space-sm)}.menu-status-text,.menu-version-text{overflow-wrap:break-word}.navigation-landmark-text{position:absolute;width:var(--ic-space-1px);height:var(--ic-space-1px);padding:0;margin:calc(-1 * var(--ic-space-1px));overflow:hidden}";

const NavigationMenu = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.icNavigationMenuClose = createEvent(this, "icNavigationMenuClose", 7);
        this.closeButton = null;
        this.hasButtons = false;
        this.hasNavigation = false;
        this.lastTabStop = null;
        this.navGroupFirst = false;
        this.navItemAboveButtons = false;
        this.closeMenu = () => {
            this.icNavigationMenuClose.emit();
        };
        this.focusCloseButton = () => {
            if (this.closeButton.focus) {
                this.closeButton.focus();
            }
        };
        this.focusLastTabStop = () => {
            let focusEl;
            if (this.lastTabStop !== null) {
                switch (this.lastTabStop.tagName) {
                    case "IC-NAVIGATION-BUTTON":
                    case "IC-NAVIGATION-ITEM":
                    case "IC-NAVIGATION-GROUP":
                        focusEl = this.lastTabStop;
                        focusEl.focus();
                        break;
                    case "A":
                        this.lastTabStop.focus();
                        break;
                }
            }
        };
        this.status = "";
        this.version = "";
    }
    componentWillLoad() {
        this.navBarEl = document.querySelector("ic-top-navigation");
        const navigationEls = getSlotContent(this.el, "navigation");
        if (navigationEls) {
            this.hasNavigation = true;
            const lastEl = navigationEls[navigationEls.length - 1];
            if (lastEl.tagName === "IC-NAVIGATION-ITEM") {
                this.navItemAboveButtons = true;
            }
            const firstEl = navigationEls[0];
            if (firstEl.tagName === "IC-NAVIGATION-GROUP") {
                this.navGroupFirst = true;
            }
        }
        const buttonContent = getSlotContent(this.el, "buttons");
        if (buttonContent !== null) {
            this.hasButtons = true;
            this.lastTabStop = buttonContent[buttonContent.length - 1];
        }
        else {
            if (this.hasNavigation) {
                const lastEl = navigationEls[navigationEls.length - 1];
                //check for slotted content i.e. react router link
                const slotContent = getSlot(lastEl, "navigation-item");
                if (slotContent !== null) {
                    this.lastTabStop = slotContent;
                }
                else {
                    this.lastTabStop = lastEl;
                }
            }
        }
    }
    componentDidLoad() {
        this.focusCloseButton();
    }
    componentWillRender() {
        this.hasNavigation = isSlotUsed(this.el, "navigation");
        this.hasButtons = isSlotUsed(this.el, "buttons");
    }
    navItemClickHandler() {
        this.closeMenu();
    }
    handleKeyDown(ev) {
        if (ev.key === "Tab") {
            if (ev.shiftKey) {
                if (document.activeElement === this.navBarEl) {
                    ev.preventDefault();
                    this.focusLastTabStop();
                }
            }
            else if (document.activeElement === this.lastTabStop ||
                this.lastTabStop === null) {
                ev.preventDefault();
                this.focusCloseButton();
            }
        }
        else if (ev.key === "Escape") {
            this.closeMenu();
        }
    }
    render() {
        return (h(Host, null, h("div", { class: "popout-modal", onClick: this.closeMenu }), h("div", { class: "popout-menu", role: "dialog", "aria-modal": "true", "aria-label": `${this.hasNavigation ? "Navigation" : "App"} menu` }, h("span", { "aria-hidden": "true", id: "navigation-landmark-text", class: "navigation-landmark-text" }, "Main navigation"), h("nav", { "aria-labelledby": "navigation-landmark-text", "aria-hidden": this.hasNavigation ? "false" : "true" }, h("div", { class: {
                ["menu-close-button-container"]: true,
                ["nav-group-first"]: this.navGroupFirst,
            } }, h("ic-button", { ref: (el) => (this.closeButton = el), id: "menu-close-button", class: "menu-close-button", variant: "icon", size: "large", "aria-label": `Close ${this.hasNavigation ? "navigation" : "app"} menu`, onClick: this.closeMenu }, h("svg", { slot: "icon", width: "14", height: "14", viewBox: "0 0 14 14", fill: "none", xmlns: "http://www.w3.org/2000/svg" }, h("path", { d: "M14 1.41L12.59 0L7 5.59L1.41 0L0 1.41L5.59 7L0 12.59L1.41 14L7 8.41L12.59 14L14 12.59L8.41 7L14 1.41Z", fill: "#1759BC" })))), this.hasNavigation && h("slot", { name: "navigation" })), this.hasButtons && (h("div", { class: {
                ["menu-buttons-container"]: true,
                ["menu-buttons-container-nav-item-above"]: this.navItemAboveButtons,
            } }, h("slot", { name: "buttons" }))), (this.status !== "" || this.version !== "") && (h("div", { class: {
                ["menu-status-version-container"]: true,
                ["status-version-no-buttons"]: !this.hasButtons,
            } }, this.status !== "" && (h("div", { class: "menu-status" }, h("ic-typography", { variant: "label-uppercase", "aria-label": "app tag", class: "menu-status-text" }, this.status))), this.version !== "" && (h("div", { class: "menu-version" }, h("ic-typography", { variant: "label", class: "menu-version-text", "aria-label": "app version" }, this.version))))))));
    }
    get el() { return getElement(this); }
};
NavigationMenu.style = icNavigationMenuCss;

export { NavigationMenu as ic_navigation_menu };

//# sourceMappingURL=ic-navigation-menu.entry.js.map