import { r as registerInstance, c as createEvent, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { i as isSlotUsed, k as removeDisabledFalse, f as checkResizeObserver, a as onComponentRequiredPropUndefined, p as renderHiddenInput, t as hasValidationStatus } from './helpers-3905ccc4.js';
import './types-6f6b41a5.js';

const icRadioGroupCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block}ic-input-label.error{color:var(--ic-status-error)}ic-input-validation{margin-top:var(--ic-space-sm)}:host(.small) ic-input-validation{margin-top:calc(var(--ic-space-sm) / 2)}ic-input-label ic-typography{margin-bottom:var(--ic-space-sm)}:host(.small) ic-input-label ic-typography{margin-bottom:calc(var(--ic-space-sm) / 2)}:host .radio-buttons-container{display:flex;flex-direction:column;gap:var(--ic-space-xxs)}:host(.small) .radio-buttons-container{gap:var(--ic-space-xxxs)}:host .radio-buttons-container.horizontal{display:flex;flex-direction:row;gap:calc(var(--ic-space-xl) + var(--ic-space-xs))}:host(.small) .radio-buttons-container.horizontal{gap:var(--ic-space-xl)}";

const RadioGroup = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.icChange = createEvent(this, "icChange", 7);
        this.resizeObserver = null;
        this.ADDITIONAL_FIELD = "additional-field";
        this.RADIO_HORIZONTAL = "horizontal";
        this.RADIO_VERTICAL = "vertical";
        this.runResizeObserver = () => {
            this.resizeObserver = new ResizeObserver(() => {
                this.checkOrientation();
            });
            this.resizeObserver.observe(this.el);
        };
        this.handleKeyDown = (event) => {
            switch (event.key) {
                case "ArrowDown":
                case "ArrowRight":
                    this.radioOptions[this.getNextItemToSelect(this.selectedChild, true)].click();
                    event.preventDefault();
                    break;
                case "ArrowUp":
                case "ArrowLeft":
                    this.radioOptions[this.getNextItemToSelect(this.selectedChild, false)].click();
                    event.preventDefault();
            }
        };
        this.getNextItemToSelect = (currentItem, movingDown) => {
            const numRadios = this.radioOptions.length - 1;
            if (currentItem < 1) {
                currentItem = 0;
            }
            let nextItem = movingDown ? currentItem + 1 : currentItem - 1;
            //check if wrap around necessary
            if (nextItem < 0) {
                nextItem = numRadios;
            }
            else if (nextItem > numRadios) {
                nextItem = 0;
            }
            //if next item is disabled then find next
            if (this.radioOptions[nextItem].disabled) {
                nextItem = this.getNextItemToSelect(nextItem, movingDown);
            }
            return nextItem;
        };
        this.addSlotChangeListener = () => {
            this.radioContainer.addEventListener("slotchange", this.setRadioOptions);
        };
        this.setFirstRadioOptionTabIndex = (value) => {
            this.radioOptions[0].setTabIndex(value);
        };
        this.setRadioOptions = () => {
            this.selectedChild = -1;
            this.checkedValue = "";
            this.radioOptions = Array.from(this.el.querySelectorAll("ic-radio-option"));
            if (this.radioOptions.length > 0) {
                this.radioOptions.forEach((radioOption, index) => {
                    if (!radioOption.selected) {
                        radioOption.selected = this.checkedValue === radioOption.value;
                    }
                    radioOption.name = this.name;
                    radioOption.groupLabel = this.label;
                    if (radioOption.selected) {
                        this.selectedChild = index;
                        this.checkedValue = radioOption.value;
                    }
                    if (this.disabled) {
                        radioOption.disabled = true;
                    }
                });
                this.setFirstRadioOptionTabIndex(this.selectedChild > 0 ? -1 : 0);
                if (this.initialOrientation === this.RADIO_HORIZONTAL &&
                    this.radioOptions !== undefined &&
                    (this.radioOptions.length > 2 ||
                        (this.radioOptions.length === 2 &&
                            (isSlotUsed(this.radioOptions[0], this.ADDITIONAL_FIELD) ||
                                isSlotUsed(this.radioOptions[1], this.ADDITIONAL_FIELD))))) {
                    this.currentOrientation = this.RADIO_VERTICAL;
                }
            }
        };
        this.checkedValue = "";
        this.currentOrientation = undefined;
        this.initialOrientation = undefined;
        this.selectedChild = -1;
        this.disabled = false;
        this.helperText = undefined;
        this.hideLabel = false;
        this.label = undefined;
        this.name = undefined;
        this.orientation = "vertical";
        this.required = false;
        this.size = "default";
        this.small = false;
        this.validationStatus = "";
        this.validationText = "";
    }
    watchDisabledHandler(newValue) {
        this.radioOptions.forEach((radioOption) => (radioOption.disabled = newValue));
    }
    orientationChangeHandler() {
        this.initialOrientation = this.orientation;
        this.checkOrientation();
    }
    disconnectedCallback() {
        var _a, _b;
        (_a = this.resizeObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
        (_b = this.radioContainer) === null || _b === void 0 ? void 0 : _b.removeEventListener("slotchange", this.setRadioOptions);
    }
    componentWillLoad() {
        removeDisabledFalse(this.disabled, this.el);
        this.orientationChangeHandler();
        this.currentOrientation = this.initialOrientation;
    }
    componentDidLoad() {
        this.setRadioOptions();
        checkResizeObserver(this.runResizeObserver);
        this.addSlotChangeListener();
        onComponentRequiredPropUndefined([
            { prop: this.label, propName: "label" },
            { prop: this.name, propName: "name" },
        ], "Radio Group");
    }
    selectHandler({ detail, target }) {
        var _a;
        this.checkedValue = detail.value;
        const selectedOption = target;
        this.icChange.emit({
            value: this.checkedValue,
            selectedOption: {
                radio: selectedOption,
                textFieldValue: (_a = selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.querySelector("ic-text-field")) === null || _a === void 0 ? void 0 : _a.value,
            },
        });
        if (this.radioOptions !== undefined) {
            this.radioOptions.forEach((radioOption, index) => {
                radioOption.selected = this.checkedValue === radioOption.value;
                if (radioOption.selected) {
                    this.selectedChild = index;
                }
            });
            this.setFirstRadioOptionTabIndex(this.selectedChild > 0 ? -1 : 0);
        }
    }
    changeHandler() {
        const selectedOption = this.radioOptions.findIndex((radioOption) => radioOption.selected);
        if (selectedOption < 0) {
            this.setFirstRadioOptionTabIndex(0);
            this.selectedChild = selectedOption;
        }
    }
    checkOrientation() {
        var _a, _b;
        if (this.initialOrientation === this.RADIO_HORIZONTAL) {
            let totalWidth = 0;
            if (Array.isArray(this.radioOptions) && this.radioOptions.length > 0) {
                this.radioOptions.forEach(({ clientWidth }, i, arr) => {
                    totalWidth += clientWidth;
                    if (i < arr.length - 1)
                        totalWidth += 40;
                });
            }
            else {
                totalWidth = 0;
            }
            if (this.initialOrientation == this.RADIO_HORIZONTAL) {
                if (this.radioOptions !== undefined &&
                    (this.radioOptions.length > 2 ||
                        (this.radioOptions.length === 2 &&
                            (isSlotUsed(this.radioOptions[0], this.ADDITIONAL_FIELD) ||
                                isSlotUsed(this.radioOptions[1], this.ADDITIONAL_FIELD))))) {
                    this.currentOrientation = this.RADIO_VERTICAL;
                }
                else {
                    if (totalWidth >= ((_a = this.radioContainer) === null || _a === void 0 ? void 0 : _a.clientWidth)) {
                        this.currentOrientation = this.RADIO_VERTICAL;
                    }
                    else if (totalWidth < ((_b = this.radioContainer) === null || _b === void 0 ? void 0 : _b.clientWidth)) {
                        this.currentOrientation = this.RADIO_HORIZONTAL;
                    }
                }
            }
        }
    }
    render() {
        renderHiddenInput(true, this.el, this.name, this.checkedValue, this.disabled);
        return (h(Host, { onKeyDown: this.handleKeyDown, class: { small: this.small || this.size === "small" } }, h("div", { role: "radiogroup", "aria-label": `${this.label}${this.required ? ", required" : ""}` }, !this.hideLabel && (h("ic-input-label", { class: { [`${this.validationStatus}`]: true }, label: this.label, helperText: this.helperText, required: this.required, disabled: this.disabled })), h("div", { class: {
                "radio-buttons-container": true,
                horizontal: this.currentOrientation === this.RADIO_HORIZONTAL,
            }, ref: (el) => (this.radioContainer = el) }, h("slot", null))), hasValidationStatus(this.validationStatus, this.disabled) && (h("ic-input-validation", { ariaLiveMode: "polite", status: this.validationStatus, message: this.validationText }))));
    }
    get el() { return getElement(this); }
    static get watchers() { return {
        "disabled": ["watchDisabledHandler"],
        "orientation": ["orientationChangeHandler"]
    }; }
};
RadioGroup.style = icRadioGroupCss;

export { RadioGroup as ic_radio_group };

//# sourceMappingURL=ic-radio-group.entry.js.map