import { r as registerInstance, h, H as Host } from './index-d1d2c456.js';

const icSectionContainerCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}@media only screen and (max-width: 576px){:host{--section-container-margin:var(--ic-space-xs);--section-container-max-width:var(--ic-breakpoint-sm)}}@media only screen and (min-width: 577px){:host{--section-container-margin:var(--ic-space-md);--section-container-max-width:var(--ic-breakpoint-md)}}@media only screen and (min-width: 769px){:host{--section-container-margin:var(--ic-space-md);--section-container-max-width:var(--ic-breakpoint-lg)}}@media only screen and (min-width: 993px){:host{--section-container-margin:var(--ic-space-md);--section-container-max-width:var(--ic-breakpoint-xl)}}@media only screen and (min-width: 1201px){:host{--section-container-margin:var(--ic-space-lg);--section-container-max-width:var(--ic-breakpoint-xl)}}:host{display:block;padding-top:var(--ic-space-md);padding-bottom:var(--ic-space-md);box-sizing:border-box}:host(.aligned-center){max-width:var(--section-container-max-width);margin-left:auto;margin-right:auto;padding-left:var(--section-container-margin);padding-right:var(--section-container-margin)}:host(.aligned-left){max-width:var(--section-container-max-width);margin-left:var(--section-container-margin);margin-right:auto;padding-right:var(--section-container-margin)}:host(.aligned-full-width){margin-left:var(--section-container-margin);margin-right:var(--section-container-margin)}:host(.vertical-padding){padding-top:var(--ic-space-md);padding-bottom:var(--ic-space-md)}:host(.no-vertical-padding){padding-top:0;padding-bottom:0}";

const SectionContainer = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.aligned = "left";
        this.fullHeight = false;
    }
    render() {
        const { aligned, fullHeight } = this;
        return (h(Host, { class: {
                ["aligned-left"]: aligned === "left" || aligned === null,
                ["aligned-center"]: aligned === "center",
                ["aligned-full-width"]: aligned === "full-width",
                ["no-vertical-padding"]: fullHeight,
            } }, h("slot", null)));
    }
};
SectionContainer.style = icSectionContainerCss;

export { SectionContainer as ic_section_container };

//# sourceMappingURL=ic-section-container.entry.js.map