import { r as registerInstance, c as createEvent, f as forceUpdate, h, H as Host, g as getElement } from './index-d1d2c456.js';
import { j as checkSlotInChildMutations, E as getLabelFromValue, B as getFilteredMenuOptions, n as removeFormResetListener, x as inheritAttributes, k as removeDisabledFalse, m as addFormResetListener, a as onComponentRequiredPropUndefined, p as renderHiddenInput, s as getInputDescribedByText, t as hasValidationStatus, F as isMobileOrTablet, y as IC_INHERITED_ARIA } from './helpers-3905ccc4.js';
import { I as IcThemeForegroundEnum, a as IcInformationStatus } from './types-6f6b41a5.js';

const Expand = `<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
<path d="M7 9.5L12 14.5L17 9.5H7Z" fill="currentColor" />
</svg>
`;

const Clear = `<svg width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
<path d="M12.6666 4.27334L11.7266 3.33334L7.99998 7.06001L4.27331 3.33334L3.33331 4.27334L7.05998 8.00001L3.33331 11.7267L4.27331 12.6667L7.99998 8.94001L11.7266 12.6667L12.6666 11.7267L8.93998 8.00001L12.6666 4.27334Z" fill="currentColor" />
</svg>
`;

const icSelectCss = "/*! normalize.css v8.0.1 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-webkit-text-size-adjust:100%;}body{margin:0}main{display:block}h1{font-size:2em;margin:0.67em 0}hr{box-sizing:content-box;height:0;overflow:visible;}pre{font-family:monospace, monospace;font-size:1em;}a{background-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted;}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em;}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0;}button,input{overflow:visible}button,select{text-transform:none}button,[type=\"button\"],[type=\"reset\"],[type=\"submit\"]{-webkit-appearance:button}button::-moz-focus-inner,[type=\"button\"]::-moz-focus-inner,[type=\"reset\"]::-moz-focus-inner,[type=\"submit\"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type=\"button\"]:-moz-focusring,[type=\"reset\"]:-moz-focusring,[type=\"submit\"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal;}progress{vertical-align:baseline}textarea{overflow:auto}[type=\"checkbox\"],[type=\"radio\"]{box-sizing:border-box;padding:0;}[type=\"number\"]::-webkit-inner-spin-button,[type=\"number\"]::-webkit-outer-spin-button{height:auto}[type=\"search\"]{-webkit-appearance:textfield;outline-offset:-2px;}[type=\"search\"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit;}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font-style:inherit;vertical-align:baseline}:host{display:block;position:relative}:host(.full-width){width:100%}ic-input-component-container:hover{--border-color:var(--ic-action-dark-hover)}ic-input-component-container:active{--border-color:var(--ic-action-dark-active);color:var(--ic-action-dark-active)}ic-input-component-container.menu-open{--border-color:var(--ic-architectural-400);color:var(--ic-action-dark)}ic-input-validation .status-icon,ic-input-validation .statustext{visibility:visible}ic-input-validation.menu-open .status-icon,ic-input-validation.menu-open .statustext{visibility:hidden;transition:visibility 0s}ic-input-label{margin-bottom:var(--ic-space-xs) !important}select{border:0;border-radius:var(--ic-border-radius);background-color:var(--ic-architectural-white);color:var(--ic-color-primary-text);line-height:1.5rem;letter-spacing:0.005rem;width:100%;height:100%;padding-left:0.375rem;-webkit-appearance:none;-moz-appearance:none;appearance:none;background-repeat:no-repeat;background-position:right 0.375rem center;background-image:url(\"data:image/svg+xml;utf8,<svg fill='black' height='24' viewBox='0 0 24 24' width='24' xmlns='http://www.w3.org/2000/svg'><path d='M7 10l5 5 5-5z'/><path d='M0 0h24v24H0z' fill='none'/></svg>\")}select option,.select-option-selected{color:var(--ic-color-primary-text)}select:disabled{color:var(--ic-architectural-200);background-image:url(\"data:image/svg+xml;utf8,<svg fill='grey' height='24' viewBox='0 0 24 24' width='24' xmlns='http://www.w3.org/2000/svg'><path d='M7 10l5 5 5-5z'/><path d='M0 0h24v24H0z' fill='none'/></svg>\")}select:focus{border:0;outline:0}select:not([disabled]){cursor:pointer}.select-container{width:100%;display:flex;align-items:center;position:relative}.select-input{width:100%;height:100%;padding:0 0.375rem;display:flex;cursor:pointer;align-items:center;justify-content:space-between;background:none;border:none}.select-input:focus{outline:var(--ic-hc-focus-outline)}:host(:not(.disabled)) ic-input-component-container:hover .select-input{background-color:var(--ic-architectural-white)}.select-input[disabled]{pointer-events:none}:host(.searchable) .select-input{cursor:auto}.searchable-select-container{align-items:center;display:flex;width:100%;position:relative}.expand-icon{height:var(--ic-space-lg);padding-left:var(--ic-space-xs);color:var(--ic-action-dark)}.expand-icon>svg{display:inline-block;width:var(--ic-space-lg);height:var(--ic-space-lg)}:host(.disabled) .expand-icon,:host(.disabled) .expand-icon>svg>path{color:var(--ic-architectural-200)}:host(.searchable) .expand-icon{padding-left:var(--ic-space-xxs);height:2.25rem}:host(.searchable) .expand-icon>svg{height:2.25rem;padding:0 0.375rem}:host(.searchable:not(.disabled)) .expand-icon>svg{cursor:pointer}.expand-icon-open{color:var(--ic-action-dark)}.expand-icon-filled{color:var(--ic-action-dark)}.expand-icon-open,:host(.searchable) .expand-icon-open{transform:rotateX(180deg)}:host(.disabled) .value-text,.placeholder{color:var(--ic-color-tertiary-text)}.select-input-end{display:flex;align-items:center}.clear-button-container{display:flex;gap:var(--ic-space-xxs);padding-left:2.375rem;align-items:center}:host(.small) .clear-button-container{padding-left:1.875rem}.divider{width:var(--ic-border-width);background-color:var(--ic-architectural-400);margin:var(--ic-space-xxs) 0;border-radius:var(--ic-space-1px);height:var(--ic-space-lg)}:host(.small) .divider{height:var(--ic-space-md)}.clear-button{position:absolute;right:2.75rem;border-radius:var(--ic-border-radius);transition:box-shadow var(--ic-easing-transition),\n    border-radius var(--ic-easing-transition)}.clear-button:focus{background-color:var(--ic-focus-blue);box-shadow:inset 0 0 0 0.125rem var(--ic-focus-glow);border-radius:0.25rem}.clear-button:focus *{fill:white}.searchable-select-results-status{border:0;clip:rect(0, 0, 0, 0, 0);height:var(--ic-space-1px);overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:var(--ic-space-1px)}::slotted([slot=\"icon\"]){fill:var(--ic-color-tertiary-text)}.has-value ::slotted([slot=\"icon\"]){fill:var(--ic-color-primary-text)}.readonly ::slotted([slot=\"icon\"]){padding:0.375rem;margin-bottom:0.75rem}@media (forced-colors: active){.has-value ::slotted([slot=\"icon\"]){fill:currentcolor}}";

let inputIds = 0;
const MUTABLE_ATTRIBUTES = [...IC_INHERITED_ARIA, "tabindex", "title"];
const Select = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.icBlur = createEvent(this, "icBlur", 7);
        this.icChange = createEvent(this, "icChange", 7);
        this.icClear = createEvent(this, "icClear", 7);
        this.icClose = createEvent(this, "icClose", 7);
        this.icFocus = createEvent(this, "icFocus", 7);
        this.icInput = createEvent(this, "icInput", 7);
        this.icOpen = createEvent(this, "icOpen", 7);
        this.icOptionSelect = createEvent(this, "icOptionSelect", 7);
        this.icRetryLoad = createEvent(this, "icRetryLoad", 7);
        this.hasSetDefaultValue = false;
        this.inheritedAttributes = {};
        this.initialOptionsEmpty = false;
        this.inputId = `ic-select-input-${inputIds++}`;
        this.menuId = `${this.inputId}-menu`;
        this.searchableMenuItemSelected = false;
        this.ungroupedOptions = [];
        this.hostMutationObserver = null;
        // triggered when attributes of host element change
        this.hostMutationCallback = (mutationList) => {
            let forceComponentUpdate = false;
            mutationList.forEach(({ attributeName, type, addedNodes, removedNodes }) => {
                if (MUTABLE_ATTRIBUTES.includes(attributeName)) {
                    this.inheritedAttributes[attributeName] =
                        this.el.getAttribute(attributeName);
                    forceComponentUpdate = true;
                }
                else if (type === "childList") {
                    forceComponentUpdate = checkSlotInChildMutations(addedNodes, removedNodes, "icon");
                }
            });
            if (forceComponentUpdate) {
                forceUpdate(this);
            }
        };
        this.handleRetry = (ev) => {
            var _a;
            if (ev.detail.keyPressed)
                (_a = this.searchableSelectElement) === null || _a === void 0 ? void 0 : _a.focus();
            this.blurredBecauseButtonPressed = true;
            this.retryButtonClick = true;
            this.hasSetDefaultValue = true;
            this.icRetryLoad.emit({ value: this.hiddenInputValue });
        };
        this.emitIcChange = (value) => {
            if (!this.searchable) {
                this.value = value;
            }
            clearTimeout(this.debounceIcChange);
            this.debounceIcChange = window.setTimeout(() => {
                this.icChange.emit({ value: value });
            }, this.currDebounce);
        };
        this.emitImmediateIcChange = (value) => {
            this.value = value;
            clearTimeout(this.debounceIcChange);
            this.icChange.emit({ value: value });
        };
        /**
         * Processes the provided array of IcMenuOptions, removing duplicates and reporting them with a console.warn
         * @param options array of IcMenuOptions
         * @returns a new options object, with all entries possessing a duplicate 'value' field removed
         */
        this.deduplicateOptions = (options) => {
            const uniqueValues = [];
            const dedupedOptions = [];
            let dedupedChildren;
            options.forEach((option) => {
                if (option.children) {
                    //If an option has children, we will loop through them
                    dedupedChildren = [];
                    option.children.forEach((child) => {
                        if (uniqueValues.includes(child.value)) {
                            console.warn(`ic-select with label ${this.label} was populated with duplicate option (value: ${child.value}) which has been removed.`);
                        }
                        else {
                            uniqueValues.push(child.value);
                            dedupedChildren.push(child);
                        }
                    });
                    // construct a modified option, inserting the deduplicated children alongside the original information
                    const modifiedParent = Object.assign(Object.assign({}, option), { children: dedupedChildren });
                    dedupedOptions.push(modifiedParent);
                }
                else {
                    // If an option does not have children, assess to see if it's value has been included already
                    if (uniqueValues.includes(option.value)) {
                        console.warn(`ic-select with label ${this.label} was populated with duplicate option (value: ${option.value}) which has been removed.`);
                    }
                    else {
                        uniqueValues.push(option.value);
                        dedupedOptions.push(option);
                    }
                }
            });
            return dedupedOptions;
        };
        /**
         * Loop through options array and for all options with no value, infer it from the label
         */
        this.setOptionsValuesFromLabels = () => {
            var _a;
            if (((_a = this.options) === null || _a === void 0 ? void 0 : _a.length) > 0 && this.options.map) {
                this.options.map((option) => {
                    if (!option.value) {
                        option.value = option.label;
                    }
                });
            }
        };
        this.setUngroupedOptions = (event) => {
            this.ungroupedOptions = event.detail.options;
        };
        this.setTextColor = () => {
            if (this.nativeSelectElement.selectedIndex === 0) {
                this.nativeSelectElement.className = "placeholder";
            }
            else {
                this.nativeSelectElement.className = "select-option-selected";
            }
        };
        this.setMenuChange = (open) => {
            if (this.open !== open) {
                this.open = open;
            }
        };
        this.getLabelFromValue = (value) => {
            return getLabelFromValue(value, this.uniqueOptions);
        };
        this.getFilteredChildMenuOptions = (option) => {
            let children = option.children;
            if (this.searchable) {
                children = getFilteredMenuOptions(option.children, this.includeDescriptionsInSearch, this.searchableSelectInputValue, this.searchMatchPosition);
            }
            else {
                children = getFilteredMenuOptions(option.children, false, this.pressedCharacters, "start");
            }
            const newOption = Object.assign({}, option);
            newOption.children = children;
            return newOption;
        };
        this.handleNativeSelectChange = () => {
            this.icOptionSelect.emit({ value: this.nativeSelectElement.value });
            this.emitImmediateIcChange(this.nativeSelectElement.value);
            this.setTextColor();
        };
        this.handleCustomSelectChange = (event) => {
            if (this.searchable && event.detail.label === this.emptyOptionListText) {
                this.searchableSelectElement.focus();
                return;
            }
            if (this.searchable) {
                this.value = event.detail.value;
                this.searchableMenuItemSelected = true;
                // After editing the input, if selecting the same option as before, set the input value to label again
                if (this.value === this.currValue) {
                    this.searchableSelectInputValue = this.getLabelFromValue(this.value);
                }
                this.inputValueToFilter = null;
                this.hiddenInputValue = this.getValueFromLabel(this.searchableSelectInputValue);
            }
            this.ariaActiveDescendant = event.detail.optionId;
            this.icOptionSelect.emit({ value: event.detail.value });
            this.emitIcChange(event.detail.value);
        };
        this.handleMenuChange = (event) => {
            this.open = event.detail.open;
            this.pressedCharacters = "";
            this.searchable && this.handleFocusIndicatorDisplay();
        };
        // clears the debounce delay when navigating the menu with arrow keys etc
        // to prevent delay in change event, which should only occur when typing in input
        this.handleMenuKeyPress = (ev) => {
            ev.cancelBubble = true;
            this.handleCharacterKeyDown(ev.detail.key);
        };
        this.handleMenuValueChange = (ev) => {
            this.value = ev.detail.value;
        };
        this.handleFocusIndicatorDisplay = () => {
            const focusIndicator = this.el.shadowRoot.querySelector(".focus-indicator");
            if (this.open) {
                focusIndicator.classList.add("focus-indicator-enabled");
            }
            else {
                focusIndicator.classList.remove("focus-indicator-enabled");
            }
        };
        this.handleMouseDown = (event) => {
            if (!this.open) {
                event.preventDefault();
            }
        };
        this.isExternalFiltering = () => this.searchable && this.disableFilter;
        this.handleClick = (event) => {
            var _a;
            if (!this.open) {
                if (this.isExternalFiltering()) {
                    this.menu.options = this.filteredOptions;
                }
                else if (!this.hasTimedOut &&
                    !this.loading &&
                    !((_a = this.noOptions) === null || _a === void 0 ? void 0 : _a.length) &&
                    (!this.searchable || this.searchableMenuItemSelected)) {
                    this.noOptions = null;
                    this.menu.options = this.uniqueOptions;
                }
            }
            if (event.detail !== 0) {
                this.menu.handleClickOpen();
            }
        };
        this.handleExpandIconMouseDown = (event) => {
            if (!this.disabled) {
                event.preventDefault();
                this.searchableSelectElement.focus();
                this.handleClick(event);
            }
        };
        this.handleClear = (event) => {
            event.stopPropagation();
            this.hasTimedOut = false;
            clearTimeout(this.timeoutTimer);
            this.noOptions = null;
            this.emitImmediateIcChange(null);
            this.icClear.emit();
            if (this.searchable) {
                this.searchableSelectElement.value = null;
                this.searchableSelectInputValue = null;
                this.filteredOptions = this.uniqueOptions;
                this.hiddenInputValue = null;
                this.searchableSelectElement.focus();
            }
            else {
                this.customSelectElement.focus();
            }
        };
        this.handleCharacterKeyDown = (key) => {
            // Only close menu when space is pressed if not being used alongside character keys to quickly select options
            if (this.open &&
                key === " " &&
                this.pressedCharacters.length === 0 &&
                !this.hasTimedOut &&
                !this.loading) {
                this.setMenuChange(false);
            }
            if (key.length === 1 && !this.searchable) {
                window.clearTimeout(this.characterKeyPressTimer);
                this.characterKeyPressTimer = window.setTimeout(() => (this.pressedCharacters = ""), 1000);
                this.pressedCharacters += key;
                this.handleFilter();
                if (!this.noOptions) {
                    this.emitImmediateIcChange(this.filteredOptions[0].value);
                }
            }
            else {
                this.pressedCharacters = "";
            }
        };
        this.handleNativeSelectKeyDown = (event) => {
            if ((event.key !== "Escape" && event.key !== "Tab") || this.open) {
                event.cancelBubble = true;
            }
            this.handleCharacterKeyDown(event.key);
        };
        this.handleKeyDown = (event) => {
            if ((event.key !== "Escape" && event.key !== "Tab") || this.open) {
                event.cancelBubble = true;
            }
            const isArrowKey = event.key === "ArrowDown" || event.key === "ArrowUp";
            if (!this.open) {
                if (this.isExternalFiltering() && (event.key === "Enter" || isArrowKey)) {
                    this.menu.options = this.filteredOptions;
                }
                else {
                    if (!this.hasTimedOut) {
                        this.noOptions = null;
                        this.menu.options = this.uniqueOptions;
                    }
                }
            }
            if (this.open && event.key === "Enter") {
                this.setMenuChange(false);
            }
            else {
                if (!(isArrowKey && this.noOptions !== null)) {
                    if (!(event.key === " " && this.pressedCharacters.length > 0)) {
                        // Keyboard events get passed onto ic-menu
                        this.menu.handleKeyboardOpen(event);
                    }
                    this.handleCharacterKeyDown(event.key);
                }
            }
        };
        this.handleClearButtonFocus = () => {
            this.clearButtonFocused = true;
        };
        this.handleClearButtonBlur = (ev) => {
            var _a;
            const retryButton = (_a = this.menu) === null || _a === void 0 ? void 0 : _a.querySelector("#retry-button");
            if (!(this.searchableSelectElement &&
                ev.relatedTarget === this.searchableSelectElement) &&
                !(retryButton && ev.relatedTarget === retryButton)) {
                this.setMenuChange(false);
                this.handleFocusIndicatorDisplay();
            }
            this.clearButtonFocused = false;
        };
        this.handleFilter = () => {
            var _a;
            const options = this.deduplicateOptions(this.searchable ? [...this.uniqueOptions] : this.ungroupedOptions);
            let isGrouped = false;
            let newFilteredOptions = [];
            options.map((option) => {
                if (option.children)
                    isGrouped = true;
            });
            let menuOptionsFiltered;
            if (this.searchable) {
                menuOptionsFiltered = getFilteredMenuOptions(options, this.includeDescriptionsInSearch, this.inputValueToFilter, this.searchMatchPosition);
                this.searchableMenuItemSelected = false;
            }
            else {
                menuOptionsFiltered = getFilteredMenuOptions(options, false, this.pressedCharacters, "start");
            }
            if (!isGrouped &&
                ((_a = menuOptionsFiltered[0]) === null || _a === void 0 ? void 0 : _a.label) !== this.emptyOptionListText) {
                newFilteredOptions = menuOptionsFiltered;
            }
            else if (isGrouped) {
                options.map((option) => {
                    if (this.includeGroupTitlesInSearch) {
                        if (menuOptionsFiltered.indexOf(option) !== -1) {
                            newFilteredOptions.push(option);
                        }
                        else {
                            newFilteredOptions.push(this.getFilteredChildMenuOptions(option));
                        }
                    }
                    else {
                        newFilteredOptions.push(this.getFilteredChildMenuOptions(option));
                    }
                });
            }
            let noChildOptionsWhenFiltered = false;
            if (isGrouped) {
                noChildOptionsWhenFiltered = true;
                newFilteredOptions.map((option) => {
                    if (option.children.length > 0) {
                        noChildOptionsWhenFiltered = false;
                    }
                });
            }
            if (newFilteredOptions.length > 0 && !noChildOptionsWhenFiltered) {
                this.noOptions = null;
                this.filteredOptions = newFilteredOptions;
            }
            else {
                this.noOptions = [{ label: this.emptyOptionListText, value: "" }];
                this.filteredOptions = this.noOptions;
            }
        };
        /**
         * Put the select component into loading state.
         * Replace options with the loading message. If timeout is enabled, set the timeout and once passed, replace options with the loading error message
         */
        this.triggerLoading = () => {
            this.hasTimedOut = false;
            this.noOptions = [{ label: this.loadingLabel, value: "", loading: true }];
            if (this.filteredOptions !== this.noOptions && this.searchable) {
                this.filteredOptions = this.noOptions;
            }
            else if (this.uniqueOptions !== this.noOptions && !this.searchable) {
                this.uniqueOptions = this.noOptions;
            }
            if (this.timeout) {
                this.timeoutTimer = window.setTimeout(() => {
                    this.loading = false;
                    this.hasTimedOut = true;
                    this.noOptions = [
                        { label: this.loadingErrorLabel, value: "", timedOut: true },
                    ];
                    this.filteredOptions = this.noOptions;
                    if (!this.searchable)
                        this.uniqueOptions = this.noOptions;
                }, this.timeout);
            }
        };
        this.getValueFromLabel = (label) => {
            var _a;
            return (_a = this.uniqueOptions.find((option) => option.label === label)) === null || _a === void 0 ? void 0 : _a.value;
        };
        this.handleSearchableSelectInput = (event) => {
            this.searchableSelectInputValue = event.target.value;
            this.icInput.emit({ value: this.searchableSelectInputValue });
            this.emitIcChange(this.searchableSelectInputValue);
            this.hiddenInputValue = this.searchableSelectInputValue;
            this.inputValueToFilter = this.searchableSelectInputValue;
            this.setMenuChange(true);
            if (!this.disableFilter) {
                this.handleFilter();
                this.debounceAriaLiveUpdate();
            }
        };
        this.updateSearchableSelectResultAriaLive = () => {
            const searchableSelectResultsStatusEl = this.el.shadowRoot.querySelector(".searchable-select-results-status");
            if (searchableSelectResultsStatusEl) {
                if (this.noOptions !== null) {
                    searchableSelectResultsStatusEl.innerText = this.emptyOptionListText;
                }
                else {
                    searchableSelectResultsStatusEl.innerText = "";
                }
            }
        };
        this.getDefaultValue = (value) => this.getLabelFromValue(value) || value || null;
        this.onFocus = () => {
            this.icFocus.emit();
        };
        this.onBlur = ({ relatedTarget }) => {
            var _a;
            const target = relatedTarget;
            if (target !== null &&
                ((target.tagName === "UL" && target.className.includes("menu")) ||
                    (target.tagName === "LI" && target.className.includes("option")))) {
                return;
            }
            const retryButton = (_a = this.menu) === null || _a === void 0 ? void 0 : _a.querySelector("#retry-button");
            const isSearchableAndNoFocusedInternalElements = this.searchable &&
                !!this.menu &&
                target !== this.menu &&
                !Array.from(this.menu.querySelectorAll("[role='option']")).includes(target) &&
                !(this.clearButton && target === this.clearButton) &&
                !(retryButton && target === retryButton);
            if (isSearchableAndNoFocusedInternalElements) {
                if (!this.retryButtonClick) {
                    this.setMenuChange(false);
                }
                this.handleFocusIndicatorDisplay();
            }
            this.retryButtonClick = false;
            this.icBlur.emit();
        };
        this.onTimeoutBlur = (ev) => {
            if (ev.detail.ev.relatedTarget !==
                this.searchableSelectElement &&
                !this.blurredBecauseButtonPressed) {
                this.setMenuChange(false);
                this.handleFocusIndicatorDisplay();
                this.icBlur.emit();
            }
            this.blurredBecauseButtonPressed = false;
        };
        this.handleFormReset = () => {
            this.value = this.initialValue;
            if (this.searchable) {
                this.searchableSelectInputValue = this.getDefaultValue(this.value);
                this.hiddenInputValue = this.value;
            }
        };
        this.ariaActiveDescendant = undefined;
        this.clearButtonFocused = false;
        this.debounceIcChange = undefined;
        this.hiddenInputValue = undefined;
        this.noOptions = null;
        this.open = false;
        this.pressedCharacters = "";
        this.searchableSelectInputValue = null;
        this.charactersUntilSuggestions = 0;
        this.disabled = false;
        this.disableFilter = false;
        this.emptyOptionListText = "No results found";
        this.form = undefined;
        this.formaction = undefined;
        this.formenctype = undefined;
        this.formmethod = undefined;
        this.formnovalidate = undefined;
        this.formtarget = undefined;
        this.fullWidth = false;
        this.helperText = "";
        this.hideLabel = false;
        this.includeDescriptionsInSearch = false;
        this.includeGroupTitlesInSearch = false;
        this.label = undefined;
        this.loadingErrorLabel = "Loading Error";
        this.loadingLabel = "Loading...";
        this.name = this.inputId;
        this.placeholder = "Select an option";
        this.readonly = false;
        this.required = false;
        this.searchable = false;
        this.searchMatchPosition = "anywhere";
        this.selectOnEnter = false;
        this.showClearButton = false;
        this.size = "default";
        this.small = false;
        this.timeout = undefined;
        this.validationStatus = "";
        this.validationText = "";
        this.loading = false;
        this.options = [];
        this.filteredOptions = this.options;
        this.uniqueOptions = this.options;
        this.debounce = 0;
        this.currDebounce = this.debounce;
        this.value = undefined;
        this.initialValue = this.value;
        this.inputValueToFilter = this.value;
        this.currValue = this.value;
    }
    loadingHandler(newValue) {
        newValue && this.triggerLoading();
    }
    watchOptionsHandler() {
        var _a;
        if (!this.hasTimedOut) {
            this.loading = false;
            clearTimeout(this.timeoutTimer);
            if (this.isExternalFiltering()) {
                if (((_a = this.options) === null || _a === void 0 ? void 0 : _a.length) > 0) {
                    this.setOptionsValuesFromLabels();
                    this.noOptions = null;
                    this.uniqueOptions = this.deduplicateOptions(this.options);
                    this.filteredOptions = this.uniqueOptions;
                }
                else {
                    this.noOptions = [{ label: this.emptyOptionListText, value: "" }];
                    this.uniqueOptions = this.noOptions;
                    this.filteredOptions = this.noOptions;
                }
                this.updateSearchableSelectResultAriaLive();
                this.setDefaultValue();
            }
            else {
                this.setOptionsValuesFromLabels();
                this.uniqueOptions = this.deduplicateOptions(this.options);
                this.filteredOptions = this.uniqueOptions;
                if (this.initialOptionsEmpty) {
                    this.setDefaultValue();
                    this.initialOptionsEmpty = false;
                }
            }
        }
        else {
            if (!this.searchable) {
                this.options = this.noOptions;
            }
        }
    }
    debounceChangedHandler(newValue) {
        this.updateOnChangeDebounce(newValue);
    }
    valueChangedHandler() {
        if (this.value !== this.currValue) {
            this.currValue = this.value;
        }
        if (this.searchable) {
            this.searchableSelectInputValue =
                this.getLabelFromValue(this.currValue) || this.currValue;
        }
    }
    openChangedHandler() {
        this.open ? this.icOpen.emit() : this.icClose.emit();
    }
    disconnectedCallback() {
        var _a;
        removeFormResetListener(this.el, this.handleFormReset);
        (_a = this.hostMutationObserver) === null || _a === void 0 ? void 0 : _a.disconnect();
    }
    componentWillLoad() {
        var _a;
        this.inheritedAttributes = inheritAttributes(this.el, MUTABLE_ATTRIBUTES);
        removeDisabledFalse(this.disabled, this.el);
        this.setOptionsValuesFromLabels();
        addFormResetListener(this.el, this.handleFormReset);
        if (!((_a = this.options) === null || _a === void 0 ? void 0 : _a.length)) {
            this.initialOptionsEmpty = true;
            this.noOptions = [{ label: this.emptyOptionListText, value: "" }];
            this.uniqueOptions = this.noOptions;
            this.filteredOptions = this.noOptions;
        }
        else {
            this.setDefaultValue();
            this.uniqueOptions = this.deduplicateOptions(this.options);
        }
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Select");
        if (this.loading) {
            this.triggerLoading();
        }
        this.hiddenInputValue = this.searchable && this.currValue;
        this.hostMutationObserver = new MutationObserver(this.hostMutationCallback);
        this.hostMutationObserver.observe(this.el, {
            attributes: true,
            childList: true,
        });
    }
    componentDidRender() {
        if (this.nativeSelectElement && !this.disabled) {
            this.setTextColor();
        }
    }
    /**
     * Sets focus on the input box.
     */
    async setFocus() {
        if (this.nativeSelectElement) {
            this.nativeSelectElement.focus();
        }
        else if (this.customSelectElement) {
            this.customSelectElement.focus();
        }
        else if (this.searchableSelectElement) {
            this.searchableSelectElement.focus();
        }
    }
    updateOnChangeDebounce(newValue) {
        if (this.currDebounce !== newValue) {
            this.currDebounce = newValue;
        }
    }
    debounceAriaLiveUpdate() {
        clearTimeout(this.debounceAria);
        window.setTimeout(() => {
            this.updateSearchableSelectResultAriaLive();
        }, 800);
    }
    setDefaultValue() {
        if (!this.hasSetDefaultValue && this.currValue) {
            this.searchableSelectInputValue = this.getDefaultValue(this.currValue);
            this.initialValue = this.currValue;
            this.hasSetDefaultValue = true;
        }
    }
    render() {
        const { small, size, disabled, fullWidth, helperText, hideLabel, label, menuId, name, options, placeholder, readonly, required, searchable, showClearButton, validationStatus, validationText, currValue, } = this;
        renderHiddenInput(true, this.el, name, this.searchable ? this.hiddenInputValue : currValue, disabled);
        const invalid = `${validationStatus === IcInformationStatus.Error}`;
        const describedBy = getInputDescribedByText(this.inputId, helperText !== "", hasValidationStatus(this.validationStatus, this.disabled)).trim();
        let showLeftIcon = !!this.el.querySelector(`[slot="icon"]`);
        if (showLeftIcon && (disabled || (readonly && !this.value))) {
            showLeftIcon = false;
        }
        return (h(Host, { class: {
                disabled,
                searchable,
                small,
                [size]: size !== "default",
                "full-width": fullWidth,
            }, onBlur: this.onBlur }, h("ic-input-container", { readonly: readonly }, !hideLabel && (h("ic-input-label", { for: this.inputId, label: label, helperText: helperText, required: required, disabled: disabled, readonly: readonly })), h("ic-input-component-container", { ref: (el) => (this.anchorEl = el), class: { "menu-open": this.open }, small: small, size: size, fullWidth: fullWidth, disabled: disabled, readonly: readonly, validationStatus: validationStatus }, showLeftIcon && (h("span", { slot: "left-icon", class: {
                ["readonly"]: readonly,
                ["has-value"]: !!this.value,
            } }, h("slot", { name: "icon" }))), readonly ? (h("ic-typography", null, h("p", null, this.getLabelFromValue(currValue)))) : isMobileOrTablet() ? (h("select", Object.assign({ ref: (el) => (this.nativeSelectElement = el), disabled: disabled, onChange: this.handleNativeSelectChange, required: required, id: this.inputId, "aria-label": label, "aria-describedby": describedBy, "aria-invalid": invalid, onBlur: this.onBlur, onFocus: this.onFocus, onKeyDown: this.handleNativeSelectKeyDown, form: this.form }, this.inheritedAttributes), h("option", { value: "", selected: true, disabled: !showClearButton }, placeholder), options.map((option) => {
            if (option.children) {
                return (h("optgroup", { label: option.label }, option.children.map((option) => (h("option", { value: option.value, disabled: option.disabled, selected: option.value === currValue }, option.label)))));
            }
            else {
                return (h("option", { value: option.value, disabled: option.disabled, selected: option.value === currValue }, option.label));
            }
        }))) : searchable ? (h("div", { class: "searchable-select-container" }, h("input", { class: "select-input", role: "combobox", autocomplete: "off", "aria-label": label, "aria-describedby": describedBy, "aria-activedescendant": this.ariaActiveDescendant, "aria-autocomplete": "list", "aria-expanded": `${this.open}`, "aria-invalid": invalid, "aria-required": `${required}`, "aria-controls": menuId, ref: (el) => (this.searchableSelectElement = el), id: this.inputId, value: this.searchableSelectInputValue, placeholder: placeholder, disabled: disabled, onInput: this.handleSearchableSelectInput, onClick: this.handleClick, onKeyDown: this.handleKeyDown, onFocus: this.onFocus, onBlur: this.onBlur, form: this.form, formaction: this.formaction, formenctype: this.formenctype, formmethod: this.formmethod, formnovalidate: this.formnovalidate, formtarget: this.formtarget }), this.searchableSelectInputValue &&
            (showClearButton || searchable) && (h("div", { class: "clear-button-container" }, h("ic-button", { id: "clear-button", ref: (el) => (this.clearButton = el), "aria-label": this.searchableSelectInputValue && currValue === null
                ? "Clear input"
                : "Clear selection", class: "clear-button", innerHTML: Clear, onClick: this.handleClear, onFocus: this.handleClearButtonFocus, onBlur: this.handleClearButtonBlur, size: size, variant: "icon", appearance: this.clearButtonFocused
                ? IcThemeForegroundEnum.Light
                : IcThemeForegroundEnum.Dark }), h("div", { class: "divider" }))), h("span", { onMouseDown: this.handleExpandIconMouseDown, class: {
                "expand-icon": true,
                "expand-icon-open": this.open,
                "expand-icon-filled": !(currValue == null || currValue === ""),
            }, innerHTML: Expand, "aria-hidden": "true" }), h("div", { "aria-live": "polite", role: "status", class: "searchable-select-results-status" }))) : (h("div", { class: "select-container" }, h("button", { class: "select-input", ref: (el) => (this.customSelectElement = el), id: this.inputId, "aria-label": `${label}, ${this.getLabelFromValue(currValue) || placeholder}${required ? ", required" : ""}`, "aria-describedby": describedBy, "aria-invalid": invalid, "aria-haspopup": "listbox", "aria-expanded": this.open ? "true" : "false", "aria-owns": menuId, "aria-controls": menuId, disabled: disabled, onBlur: this.onBlur, onFocus: this.onFocus, onClick: this.handleClick, onMouseDown: this.handleMouseDown, onKeyDown: this.handleKeyDown }, h("ic-typography", { variant: "body", class: {
                "value-text": true,
                placeholder: this.getLabelFromValue(currValue) === undefined,
            } }, this.getLabelFromValue(currValue) || placeholder), h("div", { class: "select-input-end" }, currValue && showClearButton && (h("div", { class: "divider" })), h("span", { class: {
                "expand-icon": true,
                "expand-icon-open": this.open,
                "expand-icon-filled": !(currValue == null || currValue === ""),
            }, innerHTML: Expand, "aria-hidden": "true" }))), currValue && showClearButton && (h("ic-button", { id: "clear-button", "aria-label": "Clear selection", class: "clear-button", innerHTML: Clear, onClick: this.handleClear, onFocus: this.handleClearButtonFocus, onBlur: this.handleClearButtonBlur, size: size, variant: "icon", appearance: this.clearButtonFocused
                ? IcThemeForegroundEnum.Light
                : IcThemeForegroundEnum.Dark }))))), !isMobileOrTablet() && (h("ic-menu", { class: {
                "no-results": this.loading ||
                    this.hasTimedOut ||
                    (this.noOptions !== null &&
                        this.noOptions[0] &&
                        this.noOptions[0].label === this.emptyOptionListText),
            }, ref: (el) => (this.menu = el), inputEl: searchable
                ? this.searchableSelectElement
                : this.customSelectElement, inputLabel: label, anchorEl: this.anchorEl, small: small, size: size, menuId: menuId, open: this.open, options: searchable ? this.filteredOptions : this.uniqueOptions, value: currValue, fullWidth: fullWidth, selectOnEnter: this.selectOnEnter, onMenuStateChange: this.handleMenuChange, onMenuOptionSelect: this.handleCustomSelectChange, onMenuKeyPress: this.handleMenuKeyPress, onMenuValueChange: this.handleMenuValueChange, onUngroupedOptionsSet: this.setUngroupedOptions, onRetryButtonClicked: this.handleRetry, parentEl: this.el, onTimeoutBlur: this.onTimeoutBlur, activationType: this.searchable || this.selectOnEnter ? "manual" : "automatic" })), hasValidationStatus(this.validationStatus, this.disabled) && (h("ic-input-validation", { class: { "menu-open": this.open }, ariaLiveMode: "polite", status: validationStatus, message: validationText, for: this.inputId })))));
    }
    static get delegatesFocus() { return true; }
    get el() { return getElement(this); }
    static get watchers() { return {
        "loading": ["loadingHandler"],
        "options": ["watchOptionsHandler"],
        "debounce": ["debounceChangedHandler"],
        "value": ["valueChangedHandler"],
        "open": ["openChangedHandler"]
    }; }
};
Select.style = icSelectCss;

export { Select as ic_select };

//# sourceMappingURL=ic-select.entry.js.map