import { r as registerInstance, h, H as Host } from './index-d1d2c456.js';
import { a as onComponentRequiredPropUndefined } from './helpers-3905ccc4.js';
import { I as IcThemeForegroundEnum } from './types-6f6b41a5.js';

const icTabGroupCss = ":host{--border-bottom-color:var(--ic-architectural-300);display:block;margin-bottom:var(--ic-space-md);border-bottom:var(--ic-border-default)}:host(.inline){margin-bottom:0;border-bottom:none}.light{border-bottom:var(--ic-border-width) solid var(--ic-architectural-white)}.tabs-container{display:flex;flex-direction:row}.tabs-container::-webkit-scrollbar{display:none}";

const TabGroup = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.appearance = "dark";
        this.contextId = "default";
        this.inline = false;
        this.label = undefined;
    }
    componentDidLoad() {
        onComponentRequiredPropUndefined([{ prop: this.label, propName: "label" }], "Tab Group");
    }
    render() {
        const { appearance, label } = this;
        return (h(Host, { role: "tablist", "aria-label": label, class: {
                ["light"]: appearance === IcThemeForegroundEnum.Light,
                ["inline"]: this.inline,
            } }, h("ic-horizontal-scroll", { appearance: appearance === IcThemeForegroundEnum.Dark
                ? IcThemeForegroundEnum.Default
                : appearance, "focus-trigger": "tabFocus" }, h("div", { class: "tabs-container" }, h("slot", null)))));
    }
    static get delegatesFocus() { return true; }
};
TabGroup.style = icTabGroupCss;

export { TabGroup as ic_tab_group };

//# sourceMappingURL=ic-tab-group.entry.js.map