import { r as registerInstance, c as createEvent, h, H as Host } from './index-d1d2c456.js';
import { J as getThemeColorBrightness, K as BLACK_MIN_COLOR_BRIGHTNESS, W as WHITE_MAX_COLOR_BRIGHTNESS, c as convertToRGBA, b as getThemeForegroundColor } from './helpers-3905ccc4.js';
import './types-6f6b41a5.js';

const Theme = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.themeChange = createEvent(this, "themeChange", 7);
        this.checkThemeColorContrast = () => {
            if (getThemeColorBrightness() < BLACK_MIN_COLOR_BRIGHTNESS &&
                getThemeColorBrightness() > WHITE_MAX_COLOR_BRIGHTNESS) {
                console.warn(`The theme colour does not provide enough contrast with either of the ICDS black or white foreground colours. Consider choosing a colour with a different brightness to achieve sufficient colour contrast for good visibility. See https://www.w3.org/TR/AERT/#color-contrast for more information about colour contrast.`);
            }
        };
        this.setThemeColor = () => {
            const colorRGBA = convertToRGBA(this.color);
            if (colorRGBA) {
                const { r, g, b, a } = colorRGBA;
                const { style } = document.documentElement;
                style.setProperty("--ic-theme-primary-r", `${r}`);
                style.setProperty("--ic-theme-primary-g", `${g}`);
                style.setProperty("--ic-theme-primary-b", `${b}`);
                style.setProperty("--ic-theme-primary-a", `${a}`);
                this.checkThemeColorContrast();
                this.themeChange.emit({
                    mode: getThemeForegroundColor(),
                    color: colorRGBA,
                });
            }
        };
        this.color = null;
    }
    watchColorPropHandler() {
        this.setThemeColor();
    }
    componentWillLoad() {
        this.setThemeColor();
    }
    render() {
        return h(Host, null);
    }
    static get watchers() { return {
        "color": ["watchColorPropHandler"]
    }; }
};

export { Theme as ic_theme };

//# sourceMappingURL=ic-theme.entry.js.map