import { IcThemeForeground, IcSizes } from "../../utils/types";
/**
 * @slot group-title - Content is placed as the accordion group title.
 */
export declare class AccordionGroup {
    private accordionGroupId;
    private allButtonEl;
    el: HTMLIcAccordionGroupElement;
    accordions: HTMLIcAccordionElement[];
    areAllAccordionsOpen: boolean;
    /**
     * The accessible button label to provide more context to the 'See all/Hide all' button for screen reader users.
     */
    accessibleButtonLabel: string;
    /**
     * The appearance of the accordion group, e.g dark, or light.
     */
    appearance: IcThemeForeground;
    watchAppearanceHandler(): void;
    /**
     * If `true`, the accordion will load in an expanded state.
     */
    expanded: boolean;
    watchExpandedHandler(): void;
    /**
     * The header for the accordion group.
     */
    groupTitle: string;
    /**
     * If `true`, only one accordion will open at a time.
     */
    singleExpansion: boolean;
    /**
     * The size of the accordion.
     */
    size?: IcSizes;
    componentDidLoad(): void;
    handleAccordionClicked(event: CustomEvent): void;
    /**
     * Sets the focus on first focusable element in the accordion group. If the "See/Hide all" button is present, it will be focused.
     * Otherwise, the first accordion will be focused.
     */
    setFocus(): Promise<void>;
    private handleExpanded;
    private linkAccordions;
    private setExpandedToAreAllAccordionsOpen;
    private accordionOpenBtnText;
    render(): any;
}
