import { EventEmitter } from "../../stencil-public-runtime";
import { IcThemeForeground, IcSizes } from "../../utils/types";
/**
 * @slot heading - Content is placed as the accordion heading.
 * @slot icon - Content is placed to the left of the heading.
 */
export declare class Accordion {
    private accordionId;
    private expandedContentEl;
    private accordionBtnHeading;
    private CONTENT_VISIBILITY_PROPERTY;
    el: HTMLIcAccordionElement;
    /**
     * @internal Determines whether the light or dark variant of the accordion should be displayed.
     */
    appearance?: IcThemeForeground;
    /**
     * If `true`, the accordion will be disabled.
     */
    disabled?: boolean;
    /**
     * If `true`, the accordion appears expanded.
     */
    expanded: boolean;
    /**
     * The section header outlining section content.
     */
    heading?: string;
    /**
     * The main body message of the accordion.
     */
    message?: string;
    /**
     * The size of the accordion.
     */
    size?: IcSizes;
    /**
     * @internal Emitted when accordion is clicked.
     */
    accordionClicked: EventEmitter<{
        id: string;
    }>;
    handleExpandedWatch(): void;
    /**
     * Sets focus on accordion heading.
     */
    setFocus(): Promise<void>;
    disconnectedCallback(): void;
    componentDidLoad(): void;
    private toggleExpanded;
    private setAccordionAnimation;
    private setExpandedContentStyle;
    private hideExpandedContent;
    private animateExpandedContent;
    render(): any;
}
