import { EventEmitter } from "../../stencil-public-runtime";
import { IcStatusVariants } from "../../utils/types";
/**
 * @slot message - Content is placed to the right of the title.
 * @slot action - Content is placed to the right of the message.
 * @slot neutral-icon - A custom neutral icon is placed to the left of the title. This will override the default icon if used.
 */
export declare class Alert {
    private hostMutationObserver;
    el: HTMLIcAlertElement;
    alertTitleWrap: boolean;
    visible: boolean;
    /**
     * If `true`, the alert will have the 'alert' ARIA role and will be announced to screen readers.
     */
    announced?: boolean;
    /**
     * If `true`, the alert will have a close icon at the end to dismiss it.
     */
    dismissible?: boolean;
    /**
     * The optional title to display at the start of the alert.
     */
    heading?: string;
    /**
     * The main body message of the alert.
     */
    message?: string;
    /**
     * If `true`, the title and message will appear above and below instead of inline.
     */
    titleAbove?: boolean;
    /**
     * The variant of the alert which will be rendered.
     */
    variant?: IcStatusVariants;
    /**
     * If `true`, the default icon for the neutral variant will be appear on the left of the alert.
     */
    showDefaultIcon: boolean;
    /**
     * @deprecated This event should not be used anymore. Use icDismiss instead.
     */
    dismiss: EventEmitter<void>;
    /**
     * Is emitted when the user dismisses the alert.
     */
    icDismiss: EventEmitter<void>;
    disconnectedCallback(): void;
    componentDidLoad(): void;
    handleClick(): void;
    private dismissAction;
    private alertTitleShouldWrap;
    private hostMutationCallback;
    render(): any;
}
