import { IcBadgePositions, IcBadgeTypes, IcBadgeVariants } from "./ic-badge.types";
import { IcSizes, IcColor } from "../../utils/types";
/**
 * @slot badge-icon - Icon will be rendered inside the badge if type is set to icon.
 */
export declare class Badge {
    private ariaLabel;
    private customColorRGBA;
    private foregroundColour;
    private parentAriaLabel;
    el: HTMLIcBadgeElement;
    /**
     * The accessible label of the badge component to provide context for screen reader users.
     */
    accessibleLabel?: string;
    accessibleLabelHandler(): void;
    /**
     * The custom badge colour. This will only style the badge component if variant="custom".
     * Can be a hex value e.g. "#ff0000", RGB e.g. "rgb(255, 0, 0)", or RGBA e.g. "rgba(255, 0, 0, 1)".
     */
    customColor?: IcColor;
    customColorHandler(): void;
    /**
     * The maximum number shown on the badge appended with a +.
     * This will only be displayed if type="text" and textLabel is not empty.
     */
    maxNumber?: number;
    /**
     * The positioning of the badge in reference to the parent element.
     */
    position?: IcBadgePositions;
    /**
     * The size of the badge to be displayed.
     */
    size?: IcSizes;
    /**
     * The text displayed in the badge. This will only be displayed if type="text".
     */
    textLabel?: string;
    /**
     * The type of badge to be displayed.
     */
    type?: IcBadgeTypes;
    /**
     * The variant of the badge to be displayed.
     */
    variant?: IcBadgeVariants;
    variantHandler(): void;
    /**
     * If `true`, the badge will be displayed.
     */
    visible: boolean;
    visibleHandler(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    /**
     * @deprecated This method should not be used anymore. Use visible prop to set badge visibility.
     */
    showBadge(): Promise<void>;
    /**
     * @deprecated This method should not be used anymore. Use visible prop to set badge visibility.
     */
    hideBadge(): Promise<void>;
    private setBadgeColour;
    private getBadgeRGB;
    private getBadgeForeground;
    private getTextLabel;
    private setAccessibleLabel;
    private isAccessibleLabelDefined;
    render(): any;
}
