import { IcThemeForeground } from "../../utils/types";
/**
 * @slot icon - Content will be rendered to the left of the breadcrumb page title.
 */
export declare class Breadcrumb {
    el: HTMLIcBreadcrumbElement;
    /**
     * @internal The appearance of the breadcrumb.
     */
    appearance: IcThemeForeground;
    /**
     * If `true`, aria-current will be set on the breadcrumb.
     */
    current?: boolean;
    /**
     * The URL that the breadcrumb link points to.
     */
    href?: string;
    /**
     * The title of the breadcrumb.
     */
    pageTitle: string;
    /**
     * @internal If `true`, back icon will be displayed.
     */
    showBackIcon: boolean;
    componentWillRender(): void;
    /**
     * Sets focus on the breadcrumb.
     */
    setFocus(): Promise<void>;
    private renderDefaultBreadcrumb;
    private setSlottedCurrentPageClass;
    render(): any;
}
