import { EventEmitter } from "../../stencil-public-runtime";
import { IcButtonTypes, IcButtonVariants, IcButtonTooltipPlacement } from "./ic-button.types";
import { IcSizes, IcTheme, IcThemeForeground } from "../../utils/types";
/**
 * @slot icon - Deprecated. This slot should not be used anymore. Use left-icon or right-icon slot instead.
 * @slot left-icon - Content will be placed to the left of the button label.
 * @slot right-icon - Content will be placed to the right of the button label.
 * @slot top-icon - Content will be placed above the button label.
 * @slot badge - Badge component overlaying the top right of the button.
 * @slot router-item - Handle routing by nesting your routes in this slot. Setting loading to true will have no impact on this slot.
 */
export declare class Button {
    private buttonEl;
    private buttonIdNum;
    private hasTooltip;
    private id;
    private inheritedAttributes;
    private describedbyEl;
    private describedById;
    private mutationObserver;
    private hostMutationObserver;
    private routerSlot;
    el: HTMLIcButtonElement;
    ariaLabel: string;
    describedByContent: string;
    title: string;
    /**
     * If `fileUpload` is set to `true`, this is the accepted list of file types.
     */
    accept?: string;
    /**
     * The appearance of the button, e.g. dark, light, or the default.
     */
    appearance?: IcThemeForeground;
    /**
     * @internal Used to identify any related child component
     */
    ariaControlsId: string | boolean;
    /**
     * @internal Used to identify any related child component
     */
    ariaOwnsId: string | boolean;
    /**
     * If `true`, the button will be in disabled state.
     */
    disabled?: boolean;
    watchDisabledHandler(): void;
    /**
     * If `true`, the ic-tooltip which is shown for icon variant will be disabled. Title or aria-label must be set if this prop is not applied.
     */
    disableTooltip?: boolean;
    /**
     * If `true`, the user can save the linked URL instead of navigating to it.
     */
    download?: string | boolean;
    /**
     * If `true`, the button will show a dropdown icon.
     */
    dropdown?: boolean;
    /**
     * If `true`, the aria-expanded value will be set to true. This is only applied if the dropdown prop is also true.
     */
    dropdownExpanded?: boolean;
    /**
     * If `true`, when the button is clicked the native file explorer will be launched.
     */
    fileUpload?: boolean;
    /**
     * The name of the control for the file input, which is submitted with the form data.
     */
    fileInputName: string;
    /**
     * The <form> element to associate the button with.
     */
    form?: string;
    /**
     * The URL that processes the information submitted by the button. It overrides the action attribute of the button's form owner. Does nothing if there is no form owner.
     */
    formaction?: string;
    /**
     * The way the submitted form data is encoded.
     */
    formenctype?: string;
    /**
     * The HTTP method used to submit the form.
     */
    formmethod?: string;
    /**
     * If `true`, the form will not be validated when submitted.
     */
    formnovalidate?: boolean;
    /**
     * The place to display the response from submitting the form. It overrides the target attribute of the button's form owner.
     */
    formtarget?: string;
    /**
     * If `true`, the button will fill the width of the container.
     */
    fullWidth?: boolean;
    /**
     * The URL that the link points to. This will render the button as an "a" tag.
     */
    href?: string;
    /**
     * The human language of the linked URL.
     */
    hreflang?: string;
    /**
     * If `true`, the button will be in loading state.
     */
    loading?: boolean;
    /**
     * If `fileUpload` is set to `true`, this boolean determines whether multiple files are accepted.
     */
    multiple?: boolean;
    /**
     * How much of the referrer to send when following the link.
     */
    referrerpolicy?: ReferrerPolicy;
    /**
     * The relationship of the linked URL as space-separated link types.
     */
    rel?: string;
    /**
     * The list of the files that have been selected by a user.
     */
    selectedFiles: FileList;
    /**
     * The size of the button to be displayed.
     */
    size?: IcSizes;
    /**
     * The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe).
     */
    target?: string;
    /**
     * The position of the tooltip in relation to the button.
     */
    tooltipPlacement?: IcButtonTooltipPlacement;
    /**
     * If `true`, the secondary variant of button will have a transparent background rather than white.
     */
    transparentBackground?: boolean;
    /**
     * The type of the button.
     */
    type?: IcButtonTypes;
    /**
     * The variant of the button to be displayed.
     */
    variant?: IcButtonVariants;
    /**
     * Emitted when button has blur
     */
    icBlur: EventEmitter<void>;
    /**
     * If `fileUpload` is set to `true`, this will be emitted when a file is selected in the native explorer.
     */
    icFileSelection: EventEmitter<FileList>;
    /**
     * Emitted when button has focus
     */
    icFocus: EventEmitter<void>;
    disconnectedCallback(): void;
    componentWillUpdate(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentWillRender(): void;
    handleHostClick(event: Event): void;
    themeChangeHandler({ detail }: CustomEvent<IcTheme>): void;
    /**
     * Sets focus on the native `button`.
     */
    setFocus(): Promise<void>;
    private closeButtonTooltip;
    private hasIconSlot;
    private hasRouterSlot;
    private handleClick;
    private handleKeyDown;
    private onFocus;
    private onBlur;
    private updateTheme;
    private mutationCallback;
    private hostMutationCallback;
    private setHasTooltip;
    private isIconVariant;
    render(): any;
}
