import { IcThemeForeground } from "../../utils/types";
/**
 * @slot heading - Content will be placed at the top of the card to the right of the icon.
 * @slot message - Content will be placed in the main body of the card.
 * @slot subheading - Content will be placed below the card heading.
 * @slot adornment - Content will be placed below the card subheading.
 * @slot image-top - Content will be placed at the top of the card above all other content.
 * @slot image-mid - Content will be placed below the card heading section.
 * @slot icon - Content will be placed to the left of the card heading.
 * @slot interaction-button - Content will be placed in the top right corner of the heading section.
 * @slot interaction-controls - Content will be placed below the card message.
 * @slot expanded-content - Content will be placed below the interaction controls but will not initially be rendered.
 * @slot badge - Badge component overlaying the top right of the card.
 */
export declare class Card {
    private hostMutationObserver;
    el: HTMLIcCardElement;
    appearance?: IcThemeForeground;
    areaExpanded: boolean;
    isFocussed: boolean;
    parentEl: HTMLElement | null;
    parentIsAnchorTag: boolean;
    /**
     * If `true`, the card will be a clickable variant, instead of static.
     */
    clickable?: boolean;
    /**
     * If `true`, the card will be disabled if it is clickable.
     */
    disabled?: boolean;
    /**
     *  If `true`, the card will have an expandable area and expansion toggle button.
     */
    expandable?: boolean;
    /**
     *  If `true`, the card will fill the width of the container.
     */
    fullWidth?: boolean;
    /**
     * The heading for the card. This is required, unless a slotted heading is used.
     */
    heading?: string;
    /**
     * The URL that the clickable card link points to. If set, the clickable card will render as an "a" tag, otherwise it will render as a button.
     */
    href?: string | undefined;
    /**
     * The human language of the linked URL.
     */
    hreflang?: string;
    /**
     * The main body message of the card.
     */
    message?: string;
    /**
     * How much of the referrer to send when following the link.
     */
    referrerpolicy?: ReferrerPolicy;
    /**
     * The relationship of the linked URL as space-separated link types.
     */
    rel?: string;
    /**
     * The subheading for the card.
     */
    subheading?: string;
    /**
     * The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe).
     */
    target?: string;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    handleHostClick(event: Event): void;
    themeChangeHandler(ev: CustomEvent): void;
    /**
     * Sets focus on the card.
     */
    setFocus(): Promise<void>;
    private parentFocussed;
    private parentBlurred;
    private updateTheme;
    private toggleExpanded;
    private hostMutationCallback;
    render(): any;
}
