import { EventEmitter } from "../../stencil-public-runtime";
import { IcInformationStatusOrEmpty, IcSizes } from "../../utils/types";
import { IcChangeEventDetail } from "./ic-checkbox-group.types";
export declare class CheckboxGroup {
    el: HTMLIcCheckboxGroupElement;
    /**
     * If `true`, the checkbox group will be set to the disabled state.
     */
    disabled: boolean;
    /**
     * The helper text that will be displayed for additional field guidance.
     */
    helperText: string;
    /**
     * If `true`, the label will be hidden and the required label value will be applied as an aria-label.
     */
    hideLabel: boolean;
    /**
     * The label for the checkbox group to be displayed.
     */
    label: string;
    /**
     * The name for the checkbox group to differentiate from other groups.
     */
    name: string;
    labelNameHandler(newValue: string, oldValue: string, propName: "label" | "name"): void;
    /**
     * If `true`, the checkbox group will require a value.
     */
    required: boolean;
    /**
     * The size of the checkboxes to be displayed. This does not affect the font size of the label.
     */
    size?: IcSizes;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small: boolean;
    /**
     * The validation status - e.g. 'error' | 'warning' | 'success'.
     */
    validationStatus: IcInformationStatusOrEmpty;
    /**
     * The validation text - e.g. 'error' | 'warning' | 'success'.
     */
    validationText: string;
    /**
     * Emitted when a checkbox is checked.
     */
    icChange: EventEmitter<IcChangeEventDetail>;
    handleChange(ev: CustomEvent): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    selectHandler({ target }: CustomEvent): void;
    render(): any;
}
