import { EventEmitter } from "../../stencil-public-runtime";
import { IcAdditionalFieldTypes, IcSizes } from "../../utils/types";
/**
 * @slot additional-field - Content to be displayed alongside a checkbox.
 */
export declare class Checkbox {
    private additionalFieldContainer;
    el: HTMLIcCheckboxElement;
    /**
     * The style of additionalField that will be displayed if used.
     */
    additionalFieldDisplay: IcAdditionalFieldTypes;
    /**
     * If `true`, the checkbox will be set to the checked state.
     */
    checked?: boolean;
    initiallyChecked: boolean;
    /**
     * If `true`, the checkbox will be set to the disabled state.
     */
    disabled?: boolean;
    /**
     * The text to be displayed when dynamic.
     */
    dynamicText: string;
    /**
     * The <form> element to associate the checkbox with.
     */
    form?: string;
    /**
     * The URL that processes the information submitted by the checkbox. It overrides the action attribute of the checkbox's form owner. Does nothing if there is no form owner.
     */
    formaction?: string;
    /**
     * The way the submitted form data is encoded.
     */
    formenctype?: string;
    /**
     * The HTTP method used to submit the form.
     */
    formmethod?: string;
    /**
     * If `true`, the form will not be validated when submitted.
     */
    formnovalidate?: boolean;
    /**
     * The place to display the response from submitting the form. It overrides the target attribute of the checkbox's form owner.
     */
    formtarget?: string;
    /**
     * The group label for the checkbox.
     */
    groupLabel: string;
    /**
     * If `true`, the indeterminate state will be displayed when checked.
     */
    indeterminate: boolean;
    displayIndeterminate: boolean;
    watchIndeterminateHandler(): void;
    /**
     * The label for the checkbox.
     */
    label: string;
    /**
     * The name for the checkbox. If not set when used in a checkbox group, the name will be based on the group name.
     */
    name: string;
    /**
     * If `true`, the checkbox will behave like a native checkbox where the `indeterminate` prop sets the indeterminate visual styling, independent of the `checked` state.
     */
    nativeIndeterminateBehaviour: boolean;
    /**
     * The size of the checkbox to be displayed. This does not affect the font size of the label. If a checkbox is contained in a checkbox group, this will override the size set on checkbox group.
     */
    size?: IcSizes;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * The value for the checkbox.
     */
    value: string;
    /**
     * If `true`, the label will be hidden and the required label value will be applied as an aria-label.
     */
    hideLabel: boolean;
    /**
     * @deprecated This event should not be used anymore. Use icCheck instead.
     */
    checkboxChecked: EventEmitter<void>;
    /**
     * Emitted when a checkbox has been checked.
     */
    icCheck: EventEmitter<void>;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentDidRender(): void;
    disconnectedCallback(): void;
    /**
     * Sets focus on the checkbox.
     */
    setFocus(): Promise<void>;
    private handleClick;
    private handleFormReset;
    render(): any;
}
