import { EventEmitter } from "../../stencil-public-runtime";
import { IcChipAppearance } from "./ic-chip.types";
import { IcColor, IcEmphasisType, IcSizes } from "../../utils/types";
/**
 * @slot icon - Content will be rendered at the start of the chip.
 * @slot badge - Badge component overlaying the top right of the chip.
 */
export declare class Chip {
    private inAGGrid;
    el: HTMLIcChipElement;
    hovered: boolean;
    visible: boolean;
    /**
     * @deprecated This prop should not be used anymore. Use variant prop instead.
     */
    appearance?: IcChipAppearance;
    /**
     * The custom chip colour. This prop will be applied to the chip component if `dismissible` is set to `false`.
     * Can be a hex value e.g. "#ff0000", RGB e.g. "rgb(255, 0, 0)", or RGBA e.g. "rgba(255, 0, 0, 1)".
     */
    customColor?: IcColor;
    customColorHandler(): void;
    /**
     * If `true`, the chip will appear disabled.
     */
    disabled?: boolean;
    /**
     * If `true`, the chip will have a close button at the end to dismiss it.
     */
    dismissible?: boolean;
    /**
     * The text rendered within the chip.
     */
    label: string;
    /**
     * The size of the chip.
     */
    size?: IcSizes;
    /**
     * If `true`, the outlined variant of chip will have a transparent background rather than white.
     */
    transparentBackground?: boolean;
    /**
     * The emphasis of the chip.
     */
    variant?: IcEmphasisType;
    /**
     * @deprecated This event should not be used anymore. Use icDismiss instead.
     */
    dismiss: EventEmitter<void>;
    /**
     * Is emitted when the user dismisses the chip.
     */
    icDismiss: EventEmitter<void>;
    componentWillLoad(): void;
    componentWillRender(): void;
    componentDidLoad(): void;
    handleClick(): void;
    /**
     * Sets focus on the chip.
     */
    setFocus(): Promise<void>;
    private dismissAction;
    private mouseEnterHandler;
    private mouseLeaveHandler;
    private setChipColour;
    render(): any;
}
