import { IcSizesNoLarge } from "../../utils/types";
/**
 * @slot label - Content will be rendered in the leftmost cell.
 * @slot value - Content will be rendered to the right of the label.
 * @slot end-component - Content will be displayed in the rightmost cell.
 */
export declare class DataRow {
    private hasEndComponent;
    private resizeObserver;
    el: HTMLIcDataRowElement;
    deviceSize: number;
    entitySize: "xl" | "m" | "xs";
    /**
     * The label in the leftmost cell of the row.
     */
    label: string;
    /**
     * The size of the data row component.
     */
    size?: IcSizesNoLarge;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * The value of the middle (right if no end-component supplied) cell of the row.
     */
    value: string;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    private runResizeObserver;
    private checkLabelAbove;
    private renderCellContent;
    private labelEndComponent;
    render(): any;
}
