import { EventEmitter } from "../../stencil-public-runtime";
/**
 * @slot dialog-controls - Content will be place at the bottom of the dialog.
 * @slot heading - Content will be placed at the top of the dialog.
 * @slot label - Content will be placed above the dialog heading.
 * @slot alert - Content will be placed at the top of the content area of the dialog.
 */
export declare class Dialog {
    private backdropEl;
    private contentArea;
    private DATA_GETS_FOCUS;
    private DATA_GETS_FOCUS_SELECTOR;
    private DIALOG_CONTROLS;
    private dialogEl;
    private dialogHeight;
    private focusedElementIndex;
    private IC_TEXT_FIELD;
    private IC_ACCORDION;
    private IC_ACCORDION_GROUP;
    private interactiveElementList;
    private resizeObserver;
    private resizeTimeout;
    private sourceElement;
    private buttonOnclick0;
    private buttonOnclick1;
    private buttonOnclick2;
    el: HTMLIcDialogElement;
    dialogRendered: boolean;
    fadeIn: boolean;
    /**
     * @deprecated This prop should not be used anymore. Use an ic-alert/IcAlert component within an alert slot with a heading instead.
     */
    alertHeading?: string;
    /**
     * @deprecated This prop should not be used anymore. Use an ic-alert/IcAlert component within an alert slot with a message instead.
     */
    alertMessage?: string;
    /**
     * If set to `false`, dialog controls will not be displayed overriding buttonProps or slotted dialog controls.
     */
    buttons?: boolean;
    /**
     * If set to `false`, the dialog will not close when the backdrop is clicked.
     */
    closeOnBackdropClick?: boolean;
    /**
     * If default buttons are displayed, sets the 'primary' or rightmost button to the destructive variant. Stops initial focus being set on the 'primary' or rightmost default or slotted button.
     */
    destructive?: boolean;
    /**
     * Sets the dismiss label tooltip and aria label.
     */
    dismissLabel?: string;
    /**
     * If set to `true`, the content area max height and overflow properties are removed allowing the dialog to stretch below the fold.
     * This prop also prevents popover elements from being cut off within the content area.
     */
    disableHeightConstraint?: boolean;
    /**
     * If set to `true`, the content area width property is removed, allowing content to take the full width of the dialog when using the large variant.
     */
    disableWidthConstraint?: boolean;
    /**
     * If `true`, the close button will not be displayed.
     */
    hideCloseButton?: boolean;
    /**
     * Sets the heading for the dialog.
     */
    heading: string;
    /**
     * Sets the optional label for the dialog which appears above the heading.
     */
    label?: string;
    /**
     * If `true`, the dialog will be displayed.
     */
    open: boolean;
    watchOpenHandler(): void;
    /**
     * Sets the maximum and minimum height and width for the dialog.
     */
    size?: "small" | "medium" | "large";
    /**
     * @deprecated This prop should not be used anymore. Use an ic-alert/IcAlert component within an alert slot with a variant instead.
     */
    status?: "neutral" | "info" | "warning" | "error" | "success";
    /**
     * Sets the label and onclick functions for default buttons.
     */
    buttonProps?: {
        label: string;
        onclick: string;
    }[];
    watchPropHandler(): void;
    /**
     * Cancelation event emitted when default 'Cancel' button clicked or 'cancelDialog' method is called.
     */
    icDialogCancelled: EventEmitter<void>;
    /**
     * Emitted when dialog has closed.
     */
    icDialogClosed: EventEmitter<void>;
    /**
     * Confirmation event emitted when default 'Confirm' primary button clicked or 'confirmDialog' method is called.
     */
    icDialogConfirmed: EventEmitter<void>;
    /**
     * Emitted when dialog has opened.
     */
    icDialogOpened: EventEmitter<void>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentDidRender(): void;
    handleKeyboard(ev: KeyboardEvent): void;
    handleClick(ev: MouseEvent): void;
    /**
     * @deprecated This method should not be used anymore. Use open prop to set dialog visibility.
     */
    showDialog(): Promise<void>;
    /**
     * @deprecated This method should not be used anymore. Use open prop to set dialog visibility.
     */
    hideDialog(): Promise<void>;
    /**
     * Cancels the dialog. Used by the default 'Cancel' button or can be called manually to trigger cancelling of dialog.
     */
    cancelDialog(): Promise<void>;
    /**
     * Confirms the dialog. Used by the default 'Confirm' button or can be called manually to trigger confirming of dialog.
     */
    confirmDialog(): Promise<void>;
    private dialogOpened;
    private runResizeObserver;
    private resizeObserverCallback;
    private refreshInteractiveElementsOnSlotChange;
    private removeSlotChangeListener;
    private setInitialFocus;
    private getFocusedElementIndex;
    private setAlertVariant;
    private closeIconClick;
    private getInteractiveElements;
    private getNextFocusEl;
    private focusNextInteractiveElement;
    private setButtonOnClick;
    private getButtonOnclick;
    private getButtonVariant;
    private loopNextFocusIndexIfLastElement;
    private setFocusIndexBasedOnShiftKey;
    private renderDialog;
    render(): any;
}
