import { IcEmptyStateAlignment } from "./ic-empty-state.types";
import { IcSizes } from "../../utils/types";
/**
 * @slot image - Content is placed at the top above all other content.
 * @slot actions - Content is placed at the bottom below all other content.
 * @slot heading - Content will be rendered in place of the heading prop.
 * @slot subheading - Content will be rendered in place of the subheading prop.
 * @slot body - Content will be rendered in place of the body prop.
 */
export declare class EmptyState {
    private hostMutationObserver;
    el: HTMLIcEmptyStateElement;
    /**
     * The alignment of the empty state container.
     */
    aligned?: IcEmptyStateAlignment;
    /**
     * The body text rendered in the empty state container.
     */
    body?: string;
    /**
     * The number of lines of body text to display before truncating.
     */
    bodyMaxLines?: number;
    /**
     * The title rendered in the empty state container.
     */
    heading?: string;
    /**
     * The size of the image or icon used in the image slot.
     */
    imageSize?: IcSizes;
    /**
     * The subtitle rendered in the empty state container.
     */
    subheading?: string;
    disconnectedCallback(): void;
    componentDidLoad(): void;
    private hostMutationCallback;
    render(): any;
}
