import { EventEmitter } from "../../stencil-public-runtime";
import { IcAlignment, IcThemeForeground } from "../../utils/types";
import { IcFooterBreakpoints } from "./ic-footer.types";
/**
 * @slot description - Content will be rendered at the top of the footer.
 * @slot link - Content will be rendered between description and logos.
 * @slot logo - Content will be rendered underneath footer links.
 * @slot caption - Content will be rendered above Crown Copyright.
 */
export declare class Footer {
    private footerEl;
    private resizeObserver;
    el: HTMLIcFooterElement;
    deviceSize: number;
    foregroundColor: IcThemeForeground;
    /**
     * The alignment of the section containers used within the footer.
     */
    aligned?: IcAlignment;
    /**
     * The screen size breakpoint at which to switch to the small layout.
     */
    breakpoint?: IcFooterBreakpoints;
    /**
     * The caption displayed at the bottom of the footer.
     */
    caption: string;
    /**
     * If `true`, the footer will display the crown copyright at the bottom.
     */
    copyright: boolean;
    /**
     * The description displayed at the top of the footer.
     */
    description: string;
    /**
     * If `true`, the footer will be set up to handle link groups instead of standalone links.
     */
    groupLinks?: boolean;
    /**
     *  @internal Triggers on page resize and triggers style changes in footer links and link groups
     */
    footerResized: EventEmitter<void>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    themeChangeHandler(ev: CustomEvent): void;
    private isSmall;
    private resizeObserverCallback;
    private runResizeObserver;
    render(): any;
}
