import { IcAlignment, IcSizesNoLarge, IcThemeForeground } from "../../utils/types";
import { IcHeroContentAlignments } from "./ic-hero.types";
/**
 * @slot heading - Content will be rendered in the title area, in place of the heading.
 * @slot subheading - Content will be rendered in the title area, in place of the subheading.
 * @slot interaction - Content will be rendered in the interaction area, adjacent to the title area.
 * @slot secondary - Content will be rendered in the secondary content area.
 */
export declare class Hero {
    private hostMutationObserver;
    el: HTMLIcHeroElement;
    foregroundColor: IcThemeForeground;
    rightContent: boolean;
    leftContentFullWidth: boolean;
    scrollFactor: string;
    /**
     * The alignment of the hero.
     */
    aligned: IcAlignment;
    /**
     * The optional background image.
     */
    backgroundImage?: string;
    /**
     * The alignment of the hero content.
     */
    contentAligned: IcHeroContentAlignments;
    /**
     * If `true`, the background image (if set) will not scroll using a parallax effect.
     */
    disableBackgroundParallax?: boolean;
    /**
     * The heading of the hero.
     */
    heading: string;
    /**
     * The optional secondary heading, replaced by slotted right content.
     */
    secondaryHeading?: string;
    /**
     * The optional secondary subheading, replaced by slotted right content.
     */
    secondarySubheading?: string;
    /**
     * The size of the hero component.
     */
    size?: IcSizesNoLarge;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * The description for the hero.
     */
    subheading?: string;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentWillRender(): void;
    themeChangeHandler(ev: CustomEvent): void;
    doScroll(): void;
    private hostMutationCallback;
    render(): any;
}
