import { IcInformationStatusOrEmpty, IcSizes } from "../../utils/types";
/**
 * @slot left-icon - Content will be placed to the left of the input.
 */
export declare class InputComponentContainer {
    private hostMutationObserver;
    el: HTMLIcInputComponentContainerElement;
    /**
     * The appearance of the input component container.
     */
    appearance?: "dark" | "default";
    /**
     * @deprecated This prop should not be used anymore. Set prop `appearance` to "dark" instead.
     */
    dark?: boolean;
    /**
     *  If `true`, the disabled state will be set.
     */
    disabled: boolean;
    /**
     *  If `true`, the input component container will fill the width of the container it is in.
     */
    fullWidth: boolean;
    /**
     *  If `true`, the input component container will allow for multiple lines.
     */
    multiLine: boolean;
    /**
     *  If `true`, the readonly state will be set.
     */
    readonly: boolean;
    /**
     * The size of the input component container component.
     */
    size?: IcSizes;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     *  If `true`, the validation will display inline.
     */
    validationInline: boolean;
    /**
     * The validation status of the input component container - e.g. 'error' | 'warning' | 'success'.
     */
    validationStatus: IcInformationStatusOrEmpty;
    componentDidLoad(): void;
    private hostMutationCallback;
    render(): any;
}
