export declare class InputLabel {
    /**
     * The appearance of the input label.
     */
    appearance?: "dark" | "default";
    /**
     * @deprecated This prop should not be used anymore. Set prop `appearance` to "dark" instead.
     */
    dark?: boolean;
    /**
     * If `true`, the disabled state will be set.
     */
    disabled: boolean;
    /**
     * If `true`, the input label will display with error styling.
     */
    error?: boolean;
    /**
     * The ID of the form element the label is bound to.
     */
    for: string;
    /**
     * The helper text that will be displayed.
     */
    helperText: string;
    /**
     * The text content of the label.
     */
    label: string;
    /**
     * If `true`, the readonly state will be set.
     */
    readonly: boolean;
    /**
     * If `true`, the input label will require a value.
     */
    required: boolean;
    componentDidLoad(): void;
    render(): any;
}
