import { IcInformationStatusOrEmpty } from "../../utils/types";
import { IcAriaLiveModeVariants } from "./ic-input-validation.types";
/**
 * @slot validation-message-adornment - Content will be placed to the right of the validation message.
 */
export declare class InputValidation {
    el: HTMLIcInputValidationElement;
    /**
     *  The ARIA live mode to apply to the message.
     */
    ariaLiveMode: IcAriaLiveModeVariants;
    /**
     * The ID of the form element the validation is bound to.
     */
    for: string;
    /**
     *  If `true`, the input validation will fill the width of the container.
     */
    fullWidth: boolean;
    /**
     * The validation message to display.
     */
    message: string;
    /**
     * The status of the validation - e.g. 'error' | 'warning' | 'success'.
     */
    status: IcInformationStatusOrEmpty;
    componentDidLoad(): void;
    render(): any;
}
