import { IcTheme, IcThemeForeground } from "../../utils/types";
/**
 * @slot router-item - Handle routing by nesting your routes in this slot.
 */
export declare class Link {
    private inheritedAttributes;
    private routerSlot;
    private hostMutationObserver;
    el: HTMLIcLinkElement;
    /**
     * The appearance of the link, e.g. dark, light, or default.
     */
    appearance?: IcThemeForeground;
    /**
     * If `true`, the user can save the linked URL instead of navigating to it.
     */
    download?: string | boolean;
    /**
     * The URL that the link points to.
     */
    href?: string;
    /**
     * The human language of the linked URL.
     */
    hreflang?: string;
    /**
     * How much of the referrer to send when following the link.
     */
    referrerpolicy?: ReferrerPolicy;
    /**
     * The relationship of the linked URL as space-separated link types.
     */
    rel?: string;
    /**
     * @deprecated This prop should not be used anymore. The 'open in new tab/window' icon will display automatically if target="_blank".
     */
    showIcon?: boolean;
    /**
     * The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe).
     */
    target?: string;
    componentWillLoad(): void;
    componentDidLoad(): void;
    disconnectedCallback(): void;
    themeChangeHandler({ detail }: CustomEvent<IcTheme>): void;
    /**
     * Sets focus on the link.
     */
    setFocus(): Promise<void>;
    private updateTheme;
    private hasRouterSlot;
    private hostMutationCallback;
    render(): any;
}
