import { IcLoadingSizes, IcLoadingTypes } from "./ic-loading-indicator.types";
import { IcThemeForegroundNoDefault } from "../../utils/types";
export declare class LoadingIndicator {
    private circularMeter;
    private innerElement?;
    private interval;
    private labelList;
    private outerElement?;
    el: HTMLIcLoadingIndicatorElement;
    circularDiameter: number;
    circularLineWidth: number;
    indeterminate: boolean;
    indicatorLabel: string;
    showSecond: boolean;
    /**
     * The appearance of the loading indicator, e.g. dark or light.
     */
    appearance?: IcThemeForegroundNoDefault;
    /**
     * The description that will be set as the aria-label of the loading indicator when not using a visible label.
     */
    description?: string;
    /**
     * If `true`, when linear, the full-width variant (i.e. without a border radius) will be displayed.
     */
    fullWidth?: boolean;
    /**
     * @internal The step number of a compact step, managed by ic-step.
     */
    innerLabel?: number;
    /**
     * The time in milliseconds before the label changes.
     */
    labelDuration?: number;
    /**
     * The maximum value that the progress value can take.
     * Used to calculate the proportional width of the progress bar.
     */
    max?: number;
    /**
     * The minimum value that the progress value can take.
     * Used to calculate the proportional width of the progress bar.
     */
    min?: number;
    /**
     * The size of the loading indicator.
     */
    size?: IcLoadingSizes;
    /**
     * The type of indicator, either linear or circular.
     */
    type?: IcLoadingTypes;
    /**
     * The label to be displayed beneath the loading indicator.
     * Display a changing label by separating multiple messages with forward slashes.
     */
    label?: string;
    watchPropHandler(): void;
    /**
     * The current amount of progress made.
     * If not provided, component acts as an indeterminate loading indicator.
     */
    progress?: number;
    watchProgressHandler(): void;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentWillUpdate(): void;
    componentDidUpdate(): void;
    private updateCircularProgressMeter;
    private getLabel;
    private getLabelVariant;
    private setCircleLineWidth;
    private setLinearDeterminateWidth;
    private calcOuterClass;
    private updateLabel;
    private setCircleXY;
    private setDashSteps;
    render(): any;
}
