import { EventEmitter } from "../../stencil-public-runtime";
import { IcMenuItemVariants } from "./ic-menu-item.types";
/**
 * @slot icon - Content will be placed to the left of the menu item label.
 */
export declare class MenuItem {
    el: HTMLIcMenuItemElement;
    toggleChecked: boolean;
    /**
     * The description displayed in the menu item, below the label.
     */
    description?: string;
    /**
     * If `true`, the menu item will be in disabled state.
     */
    disabled?: boolean;
    /**
     * The URL that the link points to. This will render the menu item as an "a" tag.
     */
    href?: string;
    /**
     * The human language of the linked URL.
     */
    hreflang?: string;
    /**
     * The label describing the keyboard shortcut for a menu item's action.
     */
    keyboardShortcut?: string;
    /**
     * The label to display in the menu item.
     */
    label: string;
    /**
     * How much of the referrer to send when following the link.
     */
    referrerpolicy?: ReferrerPolicy;
    /**
     * The relationship of the linked URL as space-separated link types.
     */
    rel?: string;
    /**
     * This references the popover menu instance that the menu item is a trigger for. If this prop is set, then the variant will always be default.
     */
    submenuTriggerFor?: string;
    /**
     * The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe).
     */
    target?: string;
    /**
     * The variant of the menu item.
     */
    variant: IcMenuItemVariants;
    /**
     * @internal Emitted when item loses focus.
     */
    childBlur: EventEmitter<void>;
    /**
     * @internal Emitted when the user clicks a menu item.
     */
    handleMenuItemClick: EventEmitter<{
        label: string;
        hasSubMenu: boolean;
    }>;
    /**
     * @internal Emitted when the user clicks a menu item that triggers a popover menu instance.
     */
    triggerPopoverMenuInstance: EventEmitter<void>;
    componentWillLoad(): void;
    componentDidLoad(): void;
    handleHostClick(e: Event): void;
    private handleClick;
    private getMenuItemAriaLabel;
    render(): any;
}
