import { EventEmitter } from "../../stencil-public-runtime";
import { IcActivationTypes, IcMenuOption, IcSizes, IcValueEventDetail } from "../../utils/types";
import { IcOptionSelectEventDetail, IcMenuChangeEventDetail, IcMenuOptionIdEventDetail } from "./ic-menu.types";
import { IcSearchBarSearchModes } from "../ic-search-bar/ic-search-bar.types";
export declare class Menu {
    private disabledOptionSelected;
    private hasPreviouslyBlurred;
    private hasTimedOut;
    private isLoading;
    private isSearchBar;
    private isSearchableSelect;
    private menu;
    private popperInstance;
    private preventClickOpen;
    private ungroupedOptions;
    host: HTMLIcMenuElement;
    focusFromSearchKeypress: boolean;
    initialOptionsListRender: boolean;
    keyboardNav: boolean;
    optionHighlighted: string;
    preventIncorrectTabOrder: boolean;
    /**
     * Determines whether options manually set as values (by pressing 'Enter') when they receive focus using keyboard navigation.
     */
    activationType?: IcActivationTypes;
    /**
     * The reference to an anchor element the menu will position itself from when rendered.
     */
    anchorEl: HTMLElement;
    /**
     * @internal If `true`, autofocus will be applied on selected item when menu is open.
     */
    autoFocusOnSelected: boolean;
    /**
     *  If `true`, the menu will fill the width of the container.
     */
    fullWidth: boolean;
    /**
     * The reference to the input element.
     */
    inputEl: HTMLElement;
    /**
     * The label for the input element.
     */
    inputLabel: string;
    /**
     * The custom name for the label field for IcMenuOption.
     */
    labelField: string;
    /**
     * The ID of the menu.
     */
    menuId: string;
    /**
     * If `true`, the menu will be displayed open.
     */
    open: boolean;
    watchOpenHandler(): void;
    /**
     * @internal - The parent element if ic-menu is nested inside another component.
     */
    parentEl?: HTMLElement;
    /**
     * Specify the mode search bar uses to search. `navigation` allows for quick lookups of a set of values, `query` allows for more general searches.
     */
    searchMode?: IcSearchBarSearchModes;
    /**
     * @internal If `true`, the icOptionSelect event will be fired on enter instead of ArrowUp and ArrowDown.
     */
    selectOnEnter?: boolean;
    /**
     * The size of the menu component.
     */
    size?: IcSizes;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * The possible menu selection options.
     */
    options: IcMenuOption[];
    watchOptionsHandler(newOptions: IcMenuOption[]): void;
    /**
     * The value of the currently selected option.
     */
    value: string;
    watchValueHandler(): void;
    /**
     * The custom name for the value field for IcMenuOption.
     */
    valueField: string;
    /**
     * @internal Emitted when key is pressed while menu is open
     */
    menuKeyPress: EventEmitter<{
        isNavKey: boolean;
        key: string;
    }>;
    /**
     * @internal Emitted when an option has been highlighted
     */
    menuOptionId: EventEmitter<IcMenuOptionIdEventDetail>;
    /**
     * @internal Emitted when an option is selected.
     */
    menuOptionSelect: EventEmitter<IcOptionSelectEventDetail>;
    /**
     * @internal Emitted when state of menu changes (i.e. open or close).
     */
    menuStateChange: EventEmitter<IcMenuChangeEventDetail>;
    /**
     * @internal Emitted when menu value changes.
     */
    menuValueChange: EventEmitter<IcValueEventDetail>;
    /**
     * @internal Emitted when the retry button is clicked
     */
    retryButtonClicked: EventEmitter<IcValueEventDetail>;
    /**
     * @internal Emitted when the timeout menu loses focus
     */
    timeoutBlur: EventEmitter<{
        ev: FocusEvent;
    }>;
    /**
     * @internal Emitted when the ungrouped options have been set.
     */
    ungroupedOptionsSet: EventEmitter<{
        options: IcMenuOption[];
    }>;
    connectedCallback(): void;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentDidUpdate(): void;
    componentDidRender(): void;
    /**
     * @internal If menu is opened with the mouse, emit menuStateChange custom event.
     */
    handleClickOpen(): Promise<void>;
    /**
     * Used alongside activationType
     * If menu is opened via keyboard navigation (i.e. Enter, ArrowUp or ArrowDown), emit optionSelect custom event.
     * @param {KeyboardEvent} event The keyboard event which is available when handleKeyboardOpen is invoked.
     */
    handleKeyboardOpen(event: KeyboardEvent): Promise<void>;
    /**
     * @internal Used to highlight the first option in the menu.
     */
    handleSetFirstOption(): Promise<void>;
    /**
     * @internal Used to initialize popperJS with an anchor element.
     * 5/12/2023: Tested with Floating UI, however, discovered inconsistent
     * boundary behaviour so sticking with PopperJS.
     */
    initPopperJs(anchor: HTMLElement): Promise<void>;
    private handleClearListener;
    private handleSubmitSearch;
    private handleMenuChange;
    private setNextOptionValue;
    private setPreviousOptionValue;
    private getParentEl;
    private arrowBehaviour;
    private setMenuOptions;
    private setHighlightedOption;
    private autoSetInputValueKeyboardOpen;
    private manSetInputValueKeyboardOpen;
    private setInputValue;
    private handleOptionClick;
    private handleRetry;
    private handleRetryKeyDown;
    private handleBlur;
    private handleMouseDown;
    private handleMenuKeyDown;
    private emitMenuKeyPress;
    private autoSetValueOnMenuKeyDown;
    private handleMenuKeyUp;
    private getOptionId;
    private getOptionAriaLabel;
    private getSortedOptions;
    private isManualMode;
    private scrollToSelected;
    private loadUngroupedOptions;
    private setMenuScrollbar;
    private handleTimeoutBlur;
    private focusOnSearchOrSelectInput;
    private optionContent;
    private displayOption;
    render(): any;
}
