import { IcThemeForeground } from "../../utils/types";
import { IcNavButtonModes } from "./ic-navigation-button.types";
/**
 * @slot icon - Content will be placed to the left of the button label.
 * @slot badge - Badge component overlaying the top right of the button.
 */
export declare class NavigationButton {
    private buttonEl;
    private inheritedAttributes;
    private hostMutationObserver;
    el: HTMLIcNavigationButtonElement;
    initialAppearance: IcThemeForeground;
    /**
     * The display mode.
     */
    mode: IcNavButtonModes;
    /**
     * If `true`, the user can save the linked URL instead of navigating to it.
     */
    download?: string | boolean;
    /**
     * The URL that the link points to. This will render the button as an "a" tag.
     */
    href?: string;
    /**
     * The human language of the linked URL.
     */
    hreflang?: string;
    /**
     * The label info to display.
     */
    label: string;
    /**
     * How much of the referrer to send when following the link.
     */
    referrerpolicy?: ReferrerPolicy;
    /**
     * The relationship of the linked URL as space-separated link types.
     */
    rel?: string;
    /**
     * The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe).
     */
    target?: string;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentWillRender(): void;
    disconnectedCallback(): void;
    navBarMenuOpenHandler(): void;
    navBarMenuCloseHandler(): void;
    themeChangeHandler(ev: CustomEvent): void;
    /**
     * Sets focus on the native `button`.
     */
    setFocus(): Promise<void>;
    private hostMutationCallback;
    render(): any;
}
