import { EventEmitter } from "../../stencil-public-runtime";
import { IcNavType, IcTheme } from "../../utils/types";
/**
 * @part link - The `<a>` within ic-navigation-item
 * @slot badge - Badge component overlaying the top right of the icon.
 * @slot icon - Content will be displayed to the left of the label for expanded navigation items, and in replacement of the label for collapsed navigation items.
 */
export declare class NavigationItem {
    private navigationSlot;
    private isInitialRender;
    private itemEl;
    el: HTMLIcNavigationItemElement;
    deviceSize: number;
    focusStyle: import("../../utils/types").IcThemeForeground;
    inTopNavSideMenu: boolean;
    isSideNavMobile: boolean;
    isTopNavChild: boolean;
    navigationType: IcNavType | "";
    parentEl: HTMLElement;
    sideNavExpanded: boolean;
    /**
     * @internal If `true`, the icon and label will be displayed when side navigation is collapsed.
     */
    collapsedIconLabel: boolean;
    /**
     * @internal If `true`, the navigation item will be displayed within a tooltip.
     */
    displayNavigationTooltip: boolean;
    /**
     * If `true`, the user can save the linked URL instead of navigating to it.
     */
    download?: string | boolean;
    /**
     *  @internal If `true`, the navigation item will be expandable.
     */
    expandable: boolean;
    /**
     * The destination of the navigation item.
     */
    href: string;
    /**
     * The human language of the linked URL.
     */
    hreflang?: string;
    /**
     * The label of the navigation item.
     */
    label: string;
    /**
     * The relationship of the linked URL as space-separated link types.
     */
    rel?: string;
    /**
     * How much of the referrer to send when following the link.
     */
    referrerpolicy?: ReferrerPolicy;
    /**
     *  If `true`, the navigation item will be set in a selected state.
     */
    selected: boolean;
    /**
     *  The place to display the linked URL, as the name for a browsing context (a tab, window, or iframe).
     */
    target?: string;
    /**
     * @internal - Emitted when item loses focus.
     */
    childBlur: EventEmitter<void>;
    /**
     * @internal - Emitted when navigation item clicked.
     */
    navItemClicked: EventEmitter<void>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidUpdate(): void;
    themeChangeHandler({ detail }: CustomEvent<IcTheme>): void;
    /**
     * Sets focus on the nav item.
     */
    setFocus(): Promise<void>;
    private displayDefaultNavigationItem;
    private topNavResizedHandler;
    private sideNavExpandHandler;
    private handleBlur;
    private handleClick;
    private generateTooltipLabel;
    private renderNavigationItemContent;
    render(): any;
}
