import { IcAlignment, IcSizesNoLarge } from "../../utils/types";
/**
 * @slot breadcrumbs - Content will be rendered in the breadcrumb area, above the title and action areas.
 * @slot heading - Content will be rendered in the title area, in place of the heading.
 * @slot subheading - Content will be rendered in the title area, in place of the subheading.
 * @slot heading-adornment - Content will be rendered in the title area, adjacent to the heading.
 * @slot actions - Content will be rendered in the action area, adjacent to the title area.
 * @slot input - Content will be rendered in the input area, below the title area and adjacent to the action area.
 * @slot stepper - Content will be rendered in the navigation area, below the title and action areas. Note: stepper slot cannot be used when the tabs slot is being used.
 * @slot tabs - Content will be rendered in the navigation area, below the title and action areas. Note: the stepper slot cannot be used when the tabs slot is being used.
 */
export declare class PageHeader {
    private resizeObserver;
    el: HTMLIcPageHeaderElement;
    actionContent: Node[];
    areButtonsReversed: boolean;
    deviceSize: number;
    /**
     * The alignment of the page header.
     */
    aligned?: IcAlignment;
    /**
     * If `true`, a border will be displayed along the bottom of the page header.
     */
    border?: boolean;
    /**
     * The title to render on the page header.
     */
    heading?: string;
    /**
     * If `true`, the reading pattern and tab order will change in the action area for viewport widths of above 576px and when actions have not wrapped.
     */
    reverseOrder?: boolean;
    /**
     * The size of the page header component.
     */
    size?: IcSizesNoLarge;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * If `true`, the page header will be sticky at all breakpoints.
     */
    sticky?: boolean;
    /**
     *  If `true`, the page header will only be sticky for viewport widths of 992px and above.
     */
    stickyDesktopOnly?: boolean;
    /**
     * The subtitle to render on the page header.
     */
    subheading?: string;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    private resizeObserverCallback;
    private runResizeObserver;
    private applyReverseOrder;
    render(): any;
}
