import { EventEmitter } from "../../stencil-public-runtime";
import { IcPaginationItemType } from "./ic-pagination-item.types";
import { IcThemeForeground } from "../../utils/types";
export declare class PaginationItem {
    el: HTMLIcPaginationItemElement;
    capitalizedLabel: string;
    /**
     * The appearance of the pagination, e.g. dark, light or the default.
     */
    appearance: IcThemeForeground;
    /**
     * If `true`, the pagination item will be disabled.
     */
    disabled: boolean;
    /**
     * The label for the pagination item (applicable when simple pagination is being used).
     */
    label: string;
    watchLabelHandler(): void;
    /**
     * The current page number.
     */
    page: number | null;
    /**
     * If `true`, the pagination item will be selected.
     */
    selected: boolean;
    /**
     * The type of pagination item - 'page' or 'ellipsis'.
     */
    type: IcPaginationItemType;
    /**
     * @internal - Emitted when a pagination item is clicked.
     */
    paginationItemClick: EventEmitter<{
        page: number;
    }>;
    componentWillLoad(): void;
    private handleClick;
    render(): any;
}
