import { EventEmitter } from "../../stencil-public-runtime";
import { IcThemeForeground } from "../../utils/types";
import { IcPaginationTypes, IcChangeEventDetail } from "./ic-pagination.types";
export declare class Pagination {
    el: HTMLIcPaginationElement;
    endEllipsis: boolean;
    endItems: number[];
    midItems: number[];
    startEllipsis: boolean;
    startItems: number[];
    /**
     * The number of pages displayed adjacent to the current page when using 'complex' type pagination. Accepted values are 0, 1 & 2.
     */
    adjacentCount: number;
    watchAdjacentCountHandler(): void;
    /**
     * The appearance of the pagination, e.g. dark, light or the default.
     */
    appearance: IcThemeForeground;
    /**
     * The number of pages displayed as boundary items to the current page when using 'complex' type pagination. Accepted values are 0, 1 & 2.
     */
    boundaryCount: number;
    watchBoundaryCountHandler(): void;
    /**
     * The default page to display.
     */
    defaultPage: number;
    /**
     * If `true`, the pagination will not allow interaction.
     */
    disabled: boolean;
    /**
     * If `true`, the current page of the simple pagination will not be displayed.
     */
    hideCurrentPage: boolean;
    /**
     * If `true`, the first and last page buttons will not be displayed.
     */
    hideFirstAndLastPageButton: boolean;
    /**
     * The label for the pagination item (applicable when simple pagination is being used).
     */
    label: string;
    /**
     * The total number of pages.
     */
    pages: number;
    watchNumberPagesHandler(): void;
    /**
     * The type of pagination to be used.
     */
    type: IcPaginationTypes;
    watchTypeHandler(): void;
    /**
     * The current page displayed by the pagination.
     */
    currentPage: number;
    watchPageChangeHandler(): void;
    /**
     * Emitted when a page is selected.
     */
    icPageChange: EventEmitter<IcChangeEventDetail>;
    componentWillLoad(): void;
    componentDidLoad(): void;
    paginationItemClickHandler(ev: CustomEvent): void;
    /**
     * Sets the currently displayed page.
     * @param {number} page The page number to set as the current page
     */
    setCurrentPage(page: number): Promise<void>;
    private handleClickFirst;
    private handleClickPrevious;
    private handleClickNext;
    private handleClickLast;
    private firstButton;
    private previousButton;
    private nextButton;
    private lastButton;
    private renderStartEllipsis;
    private renderEndEllipsis;
    private renderStartItems;
    private renderEndItems;
    private renderMiddleItems;
    render(): any;
}
