import { EventEmitter } from "../../stencil-public-runtime";
export declare class PopoverMenu {
    private anchorEl;
    private ARIA_LABEL;
    private backButton;
    private currentFocus;
    private popoverMenuEls;
    private popperInstance;
    el: HTMLIcPopoverMenuElement;
    openingFromChild: boolean;
    openingFromParent: boolean;
    /**
     * The ID of the element the popover menu will anchor itself to. This is required unless the popover is a submenu.
     */
    anchor: string;
    /**
     * @internal The parent popover menu of a child popover menu.
     */
    parentLabel?: string;
    /**
     * @internal The parent popover menu of a child popover menu.
     */
    parentPopover?: HTMLIcPopoverMenuElement;
    /**
     * The unique identifier for a popover submenu.
     */
    submenuId?: string;
    /**
     * @internal The level of menu being displayed.
     */
    submenuLevel: number;
    /**
     * If `true`, the popover menu will be displayed.
     */
    open: boolean;
    watchOpenHandler(): void;
    /**
     * Emitted when the popover menu is closed.
     */
    icPopoverClosed: EventEmitter<void>;
    disconnectedCallback(): void;
    componentDidLoad(): void;
    componentWillRender(): void;
    componentDidRender(): void;
    handleMenuItemClick(ev: CustomEvent<{
        label: string;
        hasSubMenu: boolean;
    }>): void;
    handleSubmenuChange(ev: Event): void;
    handleClick(ev: Event): void;
    handleKeyDown(ev: KeyboardEvent): void;
    /**
     * @internal Opens the menu from the child menu.
     */
    openFromChild(): Promise<void>;
    /**
     * @internal Opens the menu from the parent menu.
     */
    openFromParent(): Promise<void>;
    private setButtonFocus;
    private findAnchorEl;
    private isNotPopoverMenuEl;
    /**
     * @internal Close the menu, emit icPopoverClosed of the root popover
     * @param setFocusToAnchor when true return focus to anchor element when menu is closed
     */
    closeMenu(setFocusToAnchor?: boolean): Promise<void>;
    private getNextItemToSelect;
    private addMenuItems;
    private getMenuAriaLabel;
    private handleBackButtonClick;
    private initPopperJS;
    render(): any;
}
