import { EventEmitter } from "../../stencil-public-runtime";
import { IcInformationStatusOrEmpty, IcOrientation, IcSizesNoLarge, IcValueEventDetail } from "../../utils/types";
import { IcChangeEventDetail } from "./ic-radio-group.types";
export declare class RadioGroup {
    private radioContainer;
    private radioOptions;
    private resizeObserver;
    private ADDITIONAL_FIELD;
    private RADIO_HORIZONTAL;
    private RADIO_VERTICAL;
    el: HTMLIcRadioGroupElement;
    checkedValue: string;
    currentOrientation: IcOrientation;
    initialOrientation: IcOrientation;
    selectedChild: number;
    /**
     * If `true`, the disabled state will be set.
     */
    disabled: boolean;
    watchDisabledHandler(newValue: boolean): void;
    /**
     * The helper text that will be displayed for additional field guidance.
     */
    helperText: string;
    /**
     * If `true`, the label will be hidden and the required label value will be applied as an aria-label.
     */
    hideLabel: boolean;
    /**
     * The label for the radio group to be displayed.
     */
    label: string;
    /**
     * The name for the radio group to differentiate from other groups.
     */
    name: string;
    /**
     * The orientation of the radio buttons in the radio group. If there are more than two radio buttons in a radio group or either of the radio buttons use the `additional-field` slot, then the orientation will always be vertical.
     */
    orientation: IcOrientation;
    /**
     * If `true`, the radio group will require a value.
     */
    required: boolean;
    /**
     * The size of the radio group component.
     */
    size?: IcSizesNoLarge;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * The validation status - e.g. 'error' | 'warning' | 'success'.
     */
    validationStatus: IcInformationStatusOrEmpty;
    /**
     * The validation text - e.g. 'error' | 'warning' | 'success'.
     */
    validationText: string;
    orientationChangeHandler(): void;
    /**
     * Emitted when a user selects a radio.
     */
    icChange: EventEmitter<IcChangeEventDetail>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    selectHandler({ detail, target }: CustomEvent<IcValueEventDetail>): void;
    changeHandler(): void;
    private runResizeObserver;
    private checkOrientation;
    private handleKeyDown;
    private getNextItemToSelect;
    private addSlotChangeListener;
    private setFirstRadioOptionTabIndex;
    private setRadioOptions;
    render(): any;
}
