import { EventEmitter } from "../../stencil-public-runtime";
import { IcAdditionalFieldTypes, IcValueEventDetail } from "../../utils/types";
/**
 * @slot additional-field - Content to displayed alongside a radio option.
 */
export declare class RadioOption {
    private defaultRadioValue;
    private hasAdditionalField;
    private radioElement;
    private skipFocus;
    el: HTMLIcRadioOptionElement;
    /**
     * The style of additionalField that will be displayed if used.
     */
    additionalFieldDisplay: IcAdditionalFieldTypes;
    /**
     * If `true`, the disabled state will be set.
     */
    disabled?: boolean;
    /**
     * The text to be displayed when dynamic.
     */
    dynamicText: string;
    /**
     * The <form> element to associate the radio with.
     */
    form?: string;
    /**
     * The URL that processes the information submitted by the radio. It overrides the action attribute of the radio's form owner. Does nothing if there is no form owner.
     */
    formaction?: string;
    /**
     * The way the submitted form data is encoded.
     */
    formenctype?: string;
    /**
     * The HTTP method used to submit the form.
     */
    formmethod?: string;
    /**
     * If `true`, the form will not be validated when submitted.
     */
    formnovalidate?: boolean;
    /**
     * The place to display the response from submitting the form. It overrides the target attribute of the radio's form owner.
     */
    formtarget?: string;
    /**
     * The group label for the radio option.
     */
    groupLabel: string;
    /**
     * The label for the radio option.
     */
    label?: string;
    /**
     * The name for the radio option.
     */
    name: string;
    /**
     * The value for the radio option.
     */
    value: string;
    /**
     * If `true`, the radio option will be displayed in a selected state.
     */
    selected?: boolean;
    initiallySelected: boolean;
    watchSelectedHandler(): void;
    /**
     * Emitted when the radio option is selected.
     */
    icCheck: EventEmitter<IcValueEventDetail>;
    /**
     * @deprecated This event should not be used anymore. Use icCheck instead.
     */
    radioOptionSelect: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when the radio option is selected or deselected.
     */
    icSelectedChange: EventEmitter<void>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentWillRender(): void;
    componentDidRender(): void;
    textfieldValueHandler(event: CustomEvent<{
        value: string;
    }>): void;
    /**
     * Sets focus on the radio option.
     */
    setFocus(): Promise<void>;
    /**
     * @internal Sets the tabIndex of the radio option.
     */
    setTabIndex(value: number): Promise<void>;
    private handleClick;
    private swallowClick;
    private handleFormReset;
    render(): any;
}
