import { EventEmitter } from "../../stencil-public-runtime";
import { IcAutocompleteTypes, IcAutocorrectStates, IcMenuOption, IcSizesNoLarge } from "../../utils/types";
import { IcSearchBarBlurEventDetail, IcSearchBarSearchModes } from "./ic-search-bar.types";
import { IcValueEventDetail, IcBlurEventDetail } from "../../utils/types";
import { IcMenuChangeEventDetail, IcOptionSelectEventDetail } from "../ic-menu/ic-menu.types";
export declare class SearchBar {
    private anchorEl;
    private assistiveHintEl;
    private debounceAriaLive;
    private hasTimedOut;
    private inputEl;
    private inputId;
    private menu;
    private menuCloseFromMenuChangeEvent;
    private menuId;
    private preLoad;
    private preventSubmit;
    private prevNoOption;
    private retryButtonClick;
    private retryViaKeyPress;
    private timeoutTimer;
    private truncateValue;
    private searchSubmitButton;
    el: HTMLIcSearchBarElement;
    ariaActiveDescendant: string;
    clearButtonFocused: boolean;
    highlightedValue: string;
    open: boolean;
    searchSubmitFocused: boolean;
    showClearButton: boolean;
    /**
     * The automatic capitalisation of the text value as it is entered/edited by the user.
     * Available options: "off", "none", "on", "sentences", "words", "characters".
     */
    autocapitalize: string;
    /**
     * The state of autocompletion the browser can apply on the text value.
     */
    autocomplete?: IcAutocompleteTypes;
    /**
     * The state of autocorrection the browser can apply when the user is entering/editing the text value.
     */
    autocorrect?: IcAutocorrectStates;
    /**
     * If `true`, the form control will have input focus when the page loads.
     */
    autofocus: boolean;
    /**
     * The number of characters until suggestions appear. The submit button will be disabled until the inputted value is equal to or greater than this number.
     */
    charactersUntilSuggestion: number;
    /**
     * If `true`, the disabled state will be set.
     */
    disabled?: boolean;
    /**
     * Specify whether to disable the built in filtering. For example, if options will already be filtered from external source.
     * If `true`, all options provided will be displayed.
     */
    disableFilter?: boolean;
    /**
     * The amount of time, in milliseconds, to wait to trigger the `icChange` event after each keystroke.
     */
    debounce?: number;
    /**
     * The text displayed when there are no options in the option list.
     */
    emptyOptionListText: string;
    /**
     * If `true`, the search bar will be focused when component loaded.
     */
    focusOnLoad?: boolean;
    /**
     * Specify whether the search bar fills the full width of the container.
     * If `true`, this overrides the --input-width CSS variable.
     */
    fullWidth?: boolean;
    /**
     * The helper text that will be displayed for additional field guidance.
     */
    helperText?: string;
    /**
     * If `true`, the label will be hidden and the required label value will be applied as an aria-label.
     */
    hideLabel?: boolean;
    /**
     * The hint text for the hidden assistive description element.
     */
    hintText?: string;
    /**
     * The label for the search bar.
     */
    label: string;
    /**
     * The custom name for the label field to correspond with the IcMenuOption type.
     */
    labelField?: string;
    /**
     * Trigger loading state when fetching options asynchronously
     */
    loading?: boolean;
    /**
     * Change the message displayed when external loading times out.
     */
    loadingErrorLabel?: string;
    /**
     * Change the message displayed whilst the options are being loaded externally.
     */
    loadingLabel?: string;
    /**
     * The name of the control, which is submitted with the form data.
     */
    name: string;
    /**
     * The placeholder value to display.
     */
    placeholder?: string;
    /**
     * If `true`, the readonly state will be set.
     */
    readonly?: boolean;
    /**
     * If `true`, the search bar will require a value.
     */
    required?: boolean;
    /**
     * Specify the mode search bar uses to search. `navigation` allows for quick lookups of a set of values, `query` allows for more general searches.
     */
    searchMode?: IcSearchBarSearchModes;
    /**
     * The size of the search bar component.
     */
    size?: IcSizesNoLarge;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * If `true`, the value of the search will have its spelling and grammar checked.
     */
    spellcheck: boolean;
    /**
     * If using external filtering, set a timeout for when loading takes too long.
     */
    timeout?: number;
    /**
     * The custom name for the value field to correspond with the IcMenuOption type.
     */
    valueField?: string;
    loadingHandler(newValue: boolean): void;
    filteredOptions: IcMenuOption[];
    filteredOptionsHandler(newOptions: IcMenuOption[]): void;
    /**
     * The suggested search options.
     */
    options?: IcMenuOption[];
    watchOptionsHandler(newOptions: IcMenuOption[]): void;
    /**
     * The value of the search input.
     */
    value: string;
    watchValueHandler(newValue: string): void;
    /**
     * Emitted when the value has changed.
     */
    icChange: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when value is cleared with clear button
     */
    icClear: EventEmitter<void>;
    private handleClear;
    /**
     * Emitted when a keyboard input occurred.
     */
    icInput: EventEmitter<IcValueEventDetail>;
    private onInput;
    /**
     * @deprecated This event should not be used anymore. Use icSearchBarBlur instead.
     */
    icInputBlur: EventEmitter<IcSearchBarBlurEventDetail>;
    private onInputBlur;
    /**
     * @deprecated This event should not be used anymore. Use icSearchBarFocus instead.
     */
    icInputFocus: EventEmitter<IcValueEventDetail>;
    private onInputFocus;
    /**
     * Emitted when option is highlighted within the menu
     */
    icOptionSelect: EventEmitter<IcOptionSelectEventDetail>;
    /**
     * Emitted when the state of the menu changes (i.e. open or close)
     */
    icMenuChange: EventEmitter<IcMenuChangeEventDetail>;
    /**
     * @internal - Emitted when blur is invoked from clear button
     */
    icClearBlur: EventEmitter<IcBlurEventDetail>;
    private handleClearBlur;
    /**
     * Emitted when the 'retry loading' button is clicked
     */
    icRetryLoad: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when the search value has been submitted
     */
    icSubmitSearch: EventEmitter<IcValueEventDetail>;
    /**
     * @internal - Emitted when blur is invoked from search submit button
     */
    icSubmitSearchBlur: EventEmitter<IcBlurEventDetail>;
    private handleSubmitSearchBlur;
    /**
     * Emitted when blur is invoked from ic-search-bar
     */
    icSearchBarBlur: EventEmitter<IcSearchBarBlurEventDetail>;
    /**
     * Emitted when focus is invoked from ic-search-bar
     */
    icSearchBarFocus: EventEmitter<void>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentWillRender(): void;
    handleKeyDown(ev: CustomEvent): void;
    handleKeyUp(ev: KeyboardEvent): void;
    /**
     * Sets focus on the native `input`.
     */
    setFocus(): Promise<void>;
    private handleMouseDown;
    private handleSubmitSearchFocus;
    private handleSubmitSearch;
    private debounceAriaLiveUpdate;
    private handleSubmitSearchKeyDown;
    private handleRetry;
    private triggerLoading;
    private handleOptionSelect;
    private handleMenuOptionHighlight;
    private handleMenuChange;
    private setMenuChange;
    private handleHostFocus;
    private handleHostBlur;
    private handleShowClearButton;
    private handleFocusClearButton;
    private handleMenuCloseFromMenuChange;
    private handleTruncateValue;
    private renderAssistiveHintEl;
    private updateSearchResultAriaLive;
    private hasOptionsOrFilterDisabled;
    private hadNoOptions;
    private isSubmitDisabled;
    private highlightFirstOptionAfterNoResults;
    render(): any;
}
