import { EventEmitter } from "../../stencil-public-runtime";
import { IcInformationStatusOrEmpty, IcMenuOption, IcSearchMatchPositions, IcValueEventDetail, IcSizes } from "../../utils/types";
import { IcOptionSelectEventDetail } from "../ic-menu/ic-menu.types";
/**
 * @slot icon - Content will be placed to the left of the select text input.
 */
export declare class Select {
    private anchorEl;
    private blurredBecauseButtonPressed;
    private characterKeyPressTimer;
    private clearButton;
    private customSelectElement;
    private debounceAria;
    private hasSetDefaultValue;
    private hasTimedOut;
    private inheritedAttributes;
    private initialOptionsEmpty;
    private inputId;
    private menu;
    private menuId;
    private nativeSelectElement;
    private retryButtonClick;
    private searchableMenuItemSelected;
    private searchableSelectElement;
    private timeoutTimer;
    private ungroupedOptions;
    private hostMutationObserver;
    el: HTMLIcSelectElement;
    ariaActiveDescendant: string;
    clearButtonFocused: boolean;
    debounceIcChange: number;
    hiddenInputValue: string;
    noOptions: IcMenuOption[];
    open: boolean;
    pressedCharacters: string;
    searchableSelectInputValue: string;
    /**
     * @deprecated This prop should not be used anymore.
     */
    charactersUntilSuggestions?: number;
    /**
     * If `true`, the disabled state will be set.
     */
    disabled?: boolean;
    /**
     * If `true`, the built in filtering will be disabled for a searchable variant. For example, if options will already be filtered from external source.
     */
    disableFilter?: boolean;
    /**
     * The text displayed when there are no options in the option list.
     */
    emptyOptionListText: string;
    /**
     * The <form> element to associate the select with.
     */
    form?: string;
    /**
     * The URL that processes the information submitted by the select. It overrides the action attribute of the select's form owner. Does nothing if there is no form owner.
     * This prop should only be used with searchable select and will only be applied if searchable is true.
     */
    formaction?: string;
    /**
     * The way the submitted form data is encoded. This prop should only be used with searchable select and will only be applied if searchable is true.
     */
    formenctype?: string;
    /**
     * The HTTP method used to submit the form. This prop should only be used with searchable select and will only be applied if searchable is true.
     */
    formmethod?: string;
    /**
     * If `true`, the form will not be validated when submitted. This prop should only be used with searchable select and will only be applied if searchable is true.
     */
    formnovalidate?: boolean;
    /**
     * The place to display the response from submitting the form. It overrides the target attribute of the select's form owner.
     * This prop should only be used with searchable select and will only be applied if searchable is true.
     */
    formtarget?: string;
    /**
     * If `true`, the select element will fill the width of the container. This prop should only be used with searchable select and will only be applied if searchable is true.
     */
    fullWidth: boolean;
    /**
     * The helper text that will be displayed for additional field guidance.
     */
    helperText?: string;
    /**
     * If `true`, the label will be hidden and the required label value will be applied as an aria-label.
     */
    hideLabel?: boolean;
    /**
     * If `true`, descriptions of options will be included when filtering options in a searchable select. Only applies to built in filtering.
     */
    includeDescriptionsInSearch?: boolean;
    /**
     * If `true`, group titles of grouped options will be included when filtering options in a searchable select. Only applies to built in filtering.
     */
    includeGroupTitlesInSearch?: boolean;
    /**
     * The label for the select.
     */
    label: string;
    /**
     * The message displayed when external loading times out.
     */
    loadingErrorLabel?: string;
    /**
     * The message displayed whilst the options are being loaded externally.
     */
    loadingLabel?: string;
    /**
     * The name of the control, which is submitted with the form data.
     */
    name?: string;
    /**
     * The placeholder value to be displayed.
     */
    placeholder?: string;
    /**
     * If `true`, the readonly state will be set.
     */
    readonly?: boolean;
    /**
     * If `true`, the select will require a value.
     */
    required?: boolean;
    /**
     * If `true`, a searchable variant of the select will be displayed which can be typed in to filter options.
     */
    searchable?: boolean;
    /**
     * Whether the search string of the searchable select should match the start of or anywhere in the options. Only applies to built in filtering.
     */
    searchMatchPosition?: IcSearchMatchPositions;
    /**
     * If `true`, the icOptionSelect event will be fired on enter instead of ArrowUp and ArrowDown.
     */
    selectOnEnter?: boolean;
    /**
     * If `true`, a button which clears the select input when clicked will be displayed. The button will always appear on the searchable select.
     */
    showClearButton?: boolean;
    /**
     * The size of the select component.
     */
    size?: IcSizes;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * If using external filtering, set a timeout for when loading takes too long.
     */
    timeout?: number;
    /**
     * The validation status - e.g. 'error' | 'warning' | 'success'.
     */
    validationStatus?: IcInformationStatusOrEmpty;
    /**
     * The text to display as the validation message.
     */
    validationText?: string;
    /**
     * If `true`, the loading state will be triggered when fetching options asynchronously.
     */
    loading?: boolean;
    loadingHandler(newValue: boolean): void;
    /**
     * The possible selection options.
     */
    options?: IcMenuOption[];
    filteredOptions: IcMenuOption[];
    uniqueOptions: IcMenuOption[];
    watchOptionsHandler(): void;
    /**
     * The amount of time, in milliseconds, to wait to trigger the `icChange` event after each keystroke.
     */
    debounce?: number;
    currDebounce: number;
    debounceChangedHandler(newValue: number): void;
    /**
     * The value of the select, reflected by the value of the currently selected option. For the searchable variant, the value is also reflected by the user input.
     */
    value?: string;
    initialValue: string;
    inputValueToFilter: string;
    currValue: string;
    valueChangedHandler(): void;
    openChangedHandler(): void;
    /**
     * Emitted when the select loses focus.
     */
    icBlur: EventEmitter<void>;
    /**
     * Emitted when the value changes.
     */
    icChange: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when the clear button is clicked.
     */
    icClear: EventEmitter<void>;
    /**
     * Emitted when the select options menu is closed.
     */
    icClose: EventEmitter<void>;
    /**
     * Emitted when the select gains focus.
     */
    icFocus: EventEmitter<void>;
    /**
     * Emitted when a keyboard input occurred.
     */
    icInput: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when the select options menu is opened.
     */
    icOpen: EventEmitter<void>;
    /**
     * Emitted when an option is highlighted within the menu.
     * Highlighting a menu item will also trigger an `icChange/onIcChange` due to the value being updated.
     */
    icOptionSelect: EventEmitter<IcOptionSelectEventDetail>;
    /**
     * Emitted when the 'retry loading' button is clicked for a searchable variant.
     */
    icRetryLoad: EventEmitter<IcValueEventDetail>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    componentDidRender(): void;
    /**
     * Sets focus on the input box.
     */
    setFocus(): Promise<void>;
    private hostMutationCallback;
    private handleRetry;
    private updateOnChangeDebounce;
    private emitIcChange;
    private emitImmediateIcChange;
    /**
     * Processes the provided array of IcMenuOptions, removing duplicates and reporting them with a console.warn
     * @param options array of IcMenuOptions
     * @returns a new options object, with all entries possessing a duplicate 'value' field removed
     */
    private deduplicateOptions;
    /**
     * Loop through options array and for all options with no value, infer it from the label
     */
    private setOptionsValuesFromLabels;
    private setUngroupedOptions;
    private setTextColor;
    private setMenuChange;
    private getLabelFromValue;
    private getFilteredChildMenuOptions;
    private handleNativeSelectChange;
    private handleCustomSelectChange;
    private handleMenuChange;
    private handleMenuKeyPress;
    private handleMenuValueChange;
    private handleFocusIndicatorDisplay;
    private handleMouseDown;
    private isExternalFiltering;
    private handleClick;
    private handleExpandIconMouseDown;
    private handleClear;
    private handleCharacterKeyDown;
    private handleNativeSelectKeyDown;
    private handleKeyDown;
    private handleClearButtonFocus;
    private handleClearButtonBlur;
    private handleFilter;
    /**
     * Put the select component into loading state.
     * Replace options with the loading message. If timeout is enabled, set the timeout and once passed, replace options with the loading error message
     */
    private triggerLoading;
    private getValueFromLabel;
    private handleSearchableSelectInput;
    private updateSearchableSelectResultAriaLive;
    private debounceAriaLiveUpdate;
    private getDefaultValue;
    private setDefaultValue;
    private onFocus;
    private onBlur;
    private onTimeoutBlur;
    private handleFormReset;
    render(): any;
}
