import { EventEmitter } from "../../stencil-public-runtime";
import { IcThemeForeground } from "../../utils/types";
import { IcExpandedDetail } from "./ic-side-navigation.types";
/**
 * @slot app-icon - Content will be rendered adjacent to the app title at the very top of the side navigation.
 * @slot app-title - Handle routing by nesting a route in the app title.
 * @slot primary-navigation - Content will be rendered at the top of the side navigation.
 * @slot secondary-navigation - Content will be rendered at the bottom of the side navigation.
 */
export declare class SideNavigation {
    private ANIMATION_DURATION;
    private IC_NAVIGATION_ITEM;
    private resizeObserver;
    private COLLAPSED_ICON_LABELS_END;
    private COLLAPSED_ICON_LABELS_START;
    private menuButton;
    el: HTMLIcSideNavigationElement;
    deviceSize: number;
    deviceSizeAppTitle: number;
    foregroundColor: IcThemeForeground;
    hasSecondaryNavigation: boolean;
    menuExpanded: boolean;
    menuOpen: boolean;
    /**
     * The app title to be displayed. This is required, unless a slotted app title link is used.
     */
    appTitle: string;
    /**
     * If `true`, the icon and label will appear when side navigation is collapsed.
     */
    collapsedIconLabels: boolean;
    /**
     * If `true`, automatic parent wrapper styling will be disabled.
     */
    disableAutoParentStyling: boolean;
    /**
     * If `true`, the side navigation will not display as a top bar on small devices.
     */
    disableTopBarBehaviour: boolean;
    /**
     * If `true`, the side navigation will display in an expanded state.
     */
    expanded: boolean;
    watchExpandedHandler(): void;
    /**
     * The URL that the app title link points to.
     */
    href: string;
    /**
     * @internal If `true`, side navigation will be contained by its parent element.
     */
    inline: boolean;
    /**
     * The short title of the app to be displayed at small screen sizes in place of the app title.
     */
    shortAppTitle: string;
    /**
     * If `true`, the menu expand button will be removed (PLEASE NOTE: This takes effect on screen sizes 992px and above).
     */
    static: boolean;
    /**
     * The status of the app to be displayed.
     */
    status: string;
    /**
     * The version of the app to be displayed.
     */
    version: string;
    /**
     * Emitted when the side navigation is collapsed and expanded.
     */
    sideNavExpanded: EventEmitter<IcExpandedDetail>;
    componentWillLoad(): void;
    componentDidLoad(): void;
    disconnectedCallback(): void;
    themeChangeHandler({ detail }: CustomEvent): void;
    private emitSideNavigationExpanded;
    private toggleMenu;
    private setToggleMenuFlyoutMenuVisibility;
    private setMobileMenuAriaAttributes;
    private setAndRemoveNoWrapAfterMenuExpanded;
    private toggleMenuExpanded;
    /**
     * In order to style nested slotted elements (e.g. using React Router components), this method
     * rearranges the a tag and labels and adds inline styling expand/collapsed animations as external CSS classes are not
     * do not take affect.
     * @param menuExpanded boolean - true or false depending on side navigation state
     */
    private arrangeSlottedNavigationItem;
    private styleSlottedCollapsedIconLabels;
    private setExpandedButtonHeight;
    private styleSlottedIconLabels;
    private transitionHandler;
    private transitionEndHandler;
    private animateCollapsedIconLabels;
    private paddingIconWidth;
    private displayTooltipWithExpandedLongLabel;
    private setMenuExpanded;
    /**
     * As the mobile top bar is fixed, a padding top is required
     * to push main content down the height of the mobile top bar
     * @param value - padding-top css value
     */
    private setParentPaddingTop;
    private setParentPaddingLeft;
    private renderAppTitle;
    private resizeObserverCallback;
    private runResizeObserver;
    private setCollapsedIconLabels;
    private styleSlottedCollapsedIconLabel;
    private renderTopBar;
    render(): any;
}
