import { IcStatusTagStatuses, IcStatusTagAppearance } from "./ic-status-tag.types";
import { IcEmphasisType, IcSizes } from "../../utils/types";
export declare class StatusTag {
    /**
     * If `true`, role='status' is added to the component and it will act as an 'aria-live' region.
     * Screen readers will announce changes to the `label`, but not the initial value.
     */
    announced?: boolean;
    /**
     * @deprecated This prop should not be used anymore. Use variant prop instead.
     */
    appearance?: IcStatusTagAppearance;
    /**
     * The content rendered within the status tag.
     */
    label: string;
    /**
     * The size of the status tag component.
     */
    size?: IcSizes;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * The colour of the status tag.
     */
    status?: IcStatusTagStatuses;
    /**
     * The emphasis of the status tag.
     */
    variant?: IcEmphasisType;
    componentWillLoad(): void;
    componentDidLoad(): void;
    render(): any;
}
