import { IcStepVariants, IcStepStatuses, IcStepTypes } from "./ic-step.types";
export declare class Step {
    el: HTMLIcStepElement;
    /**
     * @internal If a compact stepper is being used, this sets the styling of the step.
     */
    compactStepStyling?: IcStepTypes;
    /**
     * @internal If `true`, and a compact stepper  is being used, the current step will be the only step in view.
     */
    current?: boolean;
    /**
     * @internal If `true`, the step will be marked as being the last one in the series. This is managed by ic-stepper.
     */
    lastStep: boolean;
    /**
     * @internal The step number of the final step. This is managed by ic-stepper.
     */
    lastStepNum?: number;
    /**
     * @internal The name of the next step. This is managed by ic-stepper.
     */
    nextStepTitle?: string;
    /**
     * @internal The progress of the next step, calculated by dividing the current step number by the total number of steps. This is managed by ic-stepper.
     */
    progress?: number;
    /**
     * @internal The step number, managed by ic-stepper.
     */
    stepNum?: number;
    /**
     * The status of the step. Use this prop to display a status message on the step if it is required or optional.
     */
    stepStatus?: IcStepStatuses;
    /**
     * Additional information about the step. Use this prop to override the default step status messaging displayed when selecting a step type or step status.
     */
    stepSubtitle?: string;
    /**
     * The title of the step within the stepper.
     */
    stepTitle?: string;
    /**
     * @internal The variant of the step. This is managed by ic-stepper.
     */
    variant: IcStepVariants;
    /**
     * The state of the step within the stepper.
     */
    stepType?: IcStepTypes;
    stepTypeChangeHandler(): void;
    render(): any;
}
