import { IcStepperAlignment } from "./ic-stepper.types";
import { IcStepTypes, IcStepVariants } from "../ic-step/ic-step.types";
export declare class Stepper {
    private resizeObserver;
    private steps;
    private stepsWithStepTitles;
    private visuallyHidden;
    el: HTMLIcStepperElement;
    alignedFullWidth: boolean;
    autoSetStepTitles: boolean;
    lastStepWidth: number;
    noOfResizes?: number;
    stepperWidth: number;
    stepTypes: IcStepTypes[];
    variantOverride?: boolean;
    /**
     * The alignment of the default stepper within its container.
     */
    aligned?: IcStepperAlignment;
    /**
     * The appearance of the stepper.
     */
    appearance?: "light" | "default";
    /**
     * The length of the connector between each step in pixels. Minimum length is 100px.
     */
    connectorWidth?: number;
    /**
     * If `true`, the information about each step, i.e. step title, step subtitle and step status, will be hidden on all default steps. The information about each step will still be visible in the compact variant of the stepper.
     */
    hideStepInfo?: boolean;
    /**
     * The variant of the stepper.
     */
    variant?: IcStepVariants;
    handlePropChange(): void;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentWillRender(): void;
    componentDidLoad(): void;
    private getChildren;
    private checkStepTitles;
    private setStepTypes;
    private setStepperWidth;
    private initialiseStepStates;
    private setHideStepInfo;
    private overrideVariant;
    private resizeObserverCallback;
    private runResizeObserver;
    render(): any;
}
