import { EventEmitter } from "../../stencil-public-runtime";
import { IcSwitchChangeEventDetail } from "./ic-switch.types";
import { IcSizesNoLarge } from "../../utils/types";
/**
 * @slot right-adornment - Content is placed to the right of switch before state label.
 */
export declare class Switch {
    private inputId;
    el: HTMLIcSwitchElement;
    checkedState: boolean;
    initiallyChecked: boolean;
    /**
     * If `true`, the switch will display as checked.
     */
    checked?: boolean;
    checkedChangeHandler(): void;
    /**
     * If `true`, the disabled state will be set.
     */
    disabled?: boolean;
    /**
     * The helper text that will be displayed for additional field guidance.
     */
    helperText?: string;
    /**
     * If `true`, the label will be hidden and the required label value will be applied as an aria-label.
     */
    hideLabel?: boolean;
    /**
     * The aria-label applied to the switch when no visual 'name' is provided.
     */
    label: string;
    /**
     * The name of the control, which is submitted with the form data.
     */
    name?: string;
    /**
     * If `true`, the switch will render the On/Off state text.
     */
    showState?: boolean;
    /**
     * The size of the switch component.
     */
    size?: IcSizesNoLarge;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * The value of the toggle does not mean if it's checked or not, use the `checked`
     * property for that.
     *
     * The value of a toggle is analogous to the value of a `<input type="checkbox">`,
     * it's only used when the toggle participates in a native `<form>`.
     */
    value?: string | null;
    /**
     * Emitted when the toggle loses focus.
     */
    icBlur: EventEmitter<void>;
    /**
     * Emitted when the value property has changed.
     */
    icChange: EventEmitter<IcSwitchChangeEventDetail>;
    /**
     * Emitted when the toggle has focus.
     */
    icFocus: EventEmitter<void>;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    /**
     * Sets focus on the switch.
     */
    setFocus(): Promise<void>;
    private handleChange;
    private onFocus;
    private onBlur;
    private handleFormReset;
    render(): any;
}
