import { EventEmitter } from "../../stencil-public-runtime";
import { IcActivationTypes, IcThemeForegroundNoDefault } from "../../utils/types";
import { IcTabClickEventDetail, IcTabSelectEventDetail } from "../ic-tab/ic-tab.types";
export declare class TabContext {
    private enabledTabs;
    private focusedTabIndex;
    private newTabPanels;
    private newTabs;
    private tabs;
    private tabGroup;
    private tabPanels;
    el: HTMLIcTabContextElement;
    selectedTab: number | null;
    /**
     * Determines whether tabs have to be manually activated (by pressing 'Enter' or 'Space') when they receive focus using keyboard navigation.
     */
    activationType?: IcActivationTypes;
    /**
     * The appearance of the tab context, e.g dark, or light.
     */
    appearance?: IcThemeForegroundNoDefault;
    watchAppearanceHandler(): void;
    /**
     * The unique context needed if using multiple tabs inside one another i.e. rendering another set of tabs inside a tab panel.
     */
    contextId?: string;
    /**
     * The selected tab to be controlled by the user. Must be used alongside the icTabSelect event to manage tab selection.
     */
    selectedTabIndex?: number;
    updateSelectedTab(newValue: number): void;
    /**
     * Emitted when a user selects a tab.
     */
    icTabSelect: EventEmitter<IcTabSelectEventDetail>;
    /**
     * @deprecated This event should not be used anymore. Use icTabSelect instead.
     */
    tabSelect: EventEmitter<IcTabSelectEventDetail>;
    componentDidLoad(): void;
    componentWillUpdate(): void;
    disconnectedCallback(): void;
    tabClickHandler(event: CustomEvent<IcTabClickEventDetail>): void;
    tabCreatedHandler(ev: CustomEvent): void;
    tabEnabledHandler(): void;
    /**
     * @internal Used to set tab/tab panel IDs when a tab/tab panel has been removed
     */
    tabRemovedHandler(hadFocus?: boolean): Promise<void>;
    private emitEvents;
    /** Sets attributes to link tab-group, tabs and tab-panels */
    private linkTabs;
    /**
     * Gets tabs and tabpanels with the same context ID using querySelector to selector the children in relation to the host
     */
    private getChildren;
    private keydownHandler;
    /** Sets the tab that is selected on initial render */
    private setInitialTab;
    /** Passes the selected tab to the tab and tab panel components */
    private configureTabs;
    private getEnabledTabs;
    /** Sets focus on tab and selects it */
    private keyboardSelectTab;
    /** Sets focus on tab without selecting it (for manual activation) */
    private keyboardFocusTab;
    render(): any;
}
