import { EventEmitter } from "../../stencil-public-runtime";
import { IcThemeForegroundNoDefault } from "../../utils/types";
export declare class TabPanel {
    el: HTMLIcTabPanelElement;
    /**
     * @internal The appearance of the tabs, e.g dark, or light.
     */
    appearance?: IcThemeForegroundNoDefault;
    /**
     * @deprecated This is no longer required.
     * The context id is passed down from `ic-tab-context`
     */
    contextId?: string;
    /**
     * @internal Emitted when a tab panel is dynamically created.
     */
    tabPanelCreated: EventEmitter<HTMLIcTabPanelElement>;
    /**
     * @internal Emitted when a tab panel is unmounted.
     */
    tabPanelRemoved: EventEmitter<void>;
    connectedCallback(): void;
    disconnectedCallback(): void;
    render(): any;
}
