import { EventEmitter } from "../../stencil-public-runtime";
import { IcTabClickEventDetail } from "./ic-tab.types";
import { IcThemeForegroundNoDefault } from "../../utils/types";
/**
 * @slot icon - Content will be rendered next to the tab label.
 * @slot badge - Badge component displayed inline with the tab.
 */
export declare class Tab {
    private focusFromClick;
    private focusTabId;
    private isInitialRender;
    el: HTMLIcTabElement;
    /** @internal Determines whether the light or dark variant of the tabs should be displayed. */
    appearance?: IcThemeForegroundNoDefault;
    /** @internal The unique context needed if using multiple tabs inside one another i.e. rendering another tabs inside a tab panel. */
    contextId?: string;
    /**
     * If `true`, the disabled state will be set.
     */
    disabled?: boolean;
    /** @internal If `true`, the tab will display with a selected indicator and tabIndex will be set. */
    selected?: boolean;
    /** @internal The shared ID between panel and tab. */
    tabId?: string;
    /** @internal The position of the tab inside the tabs array in context. */
    tabPosition?: number;
    disabledWatchHandler(): void;
    /**
     * @internal Emitted when a tab is selected.
     */
    tabClick: EventEmitter<IcTabClickEventDetail>;
    /**
     * @internal Emitted when a tab is dynamically created.
     */
    tabCreated: EventEmitter<HTMLIcTabElement>;
    /**
     * @internal Emitted when a tab's disabled prop changes
     */
    tabEnabled: EventEmitter<void>;
    /**
     * @internal Emitted when a tab is focussed.
     */
    tabFocus: EventEmitter<IcTabClickEventDetail>;
    /**
     * @internal Emitted when a tab is unmounted.
     */
    tabRemoved: EventEmitter<void>;
    connectedCallback(): void;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidUpdate(): void;
    /**
     * Sets focus on the tab.
     */
    setFocus(): Promise<void>;
    private handleClick;
    private handleFocus;
    private handleMouseDown;
    render(): any;
}
