import { EventEmitter } from "../../stencil-public-runtime";
import { IcAutocompleteTypes, IcAutocorrectStates, IcInformationStatusOrEmpty, IcValueEventDetail, IcSizesNoLarge } from "../../utils/types";
import { IcAriaAutocompleteTypes, IcTextFieldInputModes, IcTextFieldTypes } from "./ic-text-field.types";
/**
 * @slot icon - Content will be placed to the left of the text input.
 */
export declare class TextField {
    private inheritedAttributes;
    private inputEl;
    private hostMutationObserver;
    el: HTMLIcTextFieldElement;
    numChars: number;
    maxCharactersReached: boolean;
    maxCharactersError: boolean;
    minCharactersUnattained: boolean;
    maxLengthExceeded: boolean;
    maxValueExceeded: boolean;
    minValueUnattained: boolean;
    /**
     * @slot clear-button - an ic-button clear component will render as an end adornment to the input.
     * @slot search-submit-button - an ic-button search submit component will render as an end adornment to the input.
     * @slot menu - an ic-menu component will appear below the input.
     */
    /**
     * @internal The active element when focus is on the ic-menu items.
     */
    ariaActiveDescendant?: string;
    /**
     * @internal Used to identify whether inputting any text triggers more predictions
     */
    ariaAutocomplete: IcAriaAutocompleteTypes;
    /**
     * @internal Used to identify if the slotted menu is rendered
     */
    ariaExpanded: string;
    /**
     * @internal Used to identify any related child component
     */
    ariaOwns: string;
    /**
     * The automatic capitalisation of the text value as it is entered/edited by the user.
     * Available options: "off", "none", "on", "sentences", "words", "characters".
     */
    autocapitalize: string;
    /**
     * The state of autocompletion the browser can apply on the text value.
     */
    autocomplete: IcAutocompleteTypes;
    /**
     * The state of autocorrection the browser can apply when the user is entering/editing the text value.
     */
    autocorrect: IcAutocorrectStates;
    /**
     * If `true`, the form control will have input focus when the page loads.
     */
    autoFocus: boolean;
    /**
     * If `true`, the disabled state will be set.
     */
    disabled: boolean;
    /**
     * Specify whether the text field fills the full width of the container.
     * If `true`, this overrides the --input-width CSS variable.
     */
    fullWidth: boolean;
    /**
     * The helper text that will be displayed for additional field guidance.
     */
    helperText: string;
    /**
     * If `true`, the label will be hidden and the required label value will be applied as an aria-label.
     */
    hideLabel: boolean;
    /**
     * @internal If `true`, the hidden form input will stop rendering for form submission.
     */
    hiddenInput: boolean;
    /**
     * The ID for the input.
     */
    inputId?: string;
    /**
     * A hint to the browser for which keyboard to display.
     * Possible values: `"none"`, `"text"`, `"tel"`, `"url"`,
     * `"email"`, `"numeric"`, `"decimal"`, and `"search"`.
     */
    inputmode: IcTextFieldInputModes;
    /**
     * The label for the input.
     */
    label: string;
    /**
     * The maximum number that can be accepted as a value, when `type` is `number` and `rows` is `1`. (NOTE: Ensure to include visual indication of max value in `helperText` or `label`)
     */
    max: string | number;
    /**
     * The maximum number of characters that can be entered in the field. Will display an error if too many characters are entered.
     */
    maxCharacters: number;
    /**
     * The count of characters in the field. Will display a warning if the bound is reached.
     */
    maxLength: number;
    /**
     * The text to display as the validation message when the maximum length is exceeded.
     */
    maxLengthMessage: string;
    /**
     * The minimum number that can be accepted as a value, when `type` is `number` and `rows` is `1`. (NOTE: Ensure to include visual indication of min value in `helperText` or `label`)
     */
    min: string | number;
    /**
     * The minimum number of characters that can be entered in the field.
     */
    minCharacters: number;
    /**
     * The name of the control, which is submitted with the form data.
     */
    name: string;
    /**
     * The placeholder value to be displayed.
     */
    placeholder: string;
    /**
     * If `true`, the read only state will be set.
     */
    readonly: boolean;
    /**
     * If `true`, the input will require a value.
     */
    required: boolean;
    /**
     * If `true`, the multiline text area will be resizeable.
     */
    resize: boolean;
    /**
     * @internal Used to set the role if not default textbox;
     */
    role: string;
    /**
     * The number of rows to transform the text field into a text area with a specific height.
     */
    rows: number;
    /**
     * The size of the text field component.
     */
    size?: IcSizesNoLarge;
    /**
     * @deprecated This prop should not be used anymore. Set prop `size` to "small" instead.
     */
    small?: boolean;
    /**
     * If `true`, the value of the text field will have its spelling and grammar checked.
     */
    spellcheck: boolean;
    /**
     * @internal If `true`, an ellipsis will be displayed at the end of the value if the value is longer than the container.
     */
    truncateValue?: boolean;
    /**
     * The type of control to display. The default type is text.
     */
    type: IcTextFieldTypes;
    /**
     * If `true`, the icon in input control will be displayed - only applies when validationStatus ='success'.
     */
    validationInline: boolean;
    /**
     *  @internal If `true`, the validation will display inline.
     */
    validationInlineInternal: boolean;
    /**
     * The validation state - e.g. 'error' | 'warning' | 'success'.
     */
    validationStatus: IcInformationStatusOrEmpty;
    /**
     * The validation state - e.g. 'error' | 'warning' | 'success'.
     */
    validationText: string;
    /**
     * The amount of time, in milliseconds, to wait to trigger the `icChange` event after each keystroke.
     */
    debounce: number;
    private debounceChanged;
    /**
     * The value of the text field.
     */
    value: string;
    initialValue: string;
    private watchValueHandler;
    /**
     * @internal Emitted when the validationInlineInternal is `true`
     */
    getValidationText: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when input loses focus.
     */
    icBlur: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when the value has changed.
     */
    icChange: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when input gains focus.
     */
    icFocus: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when a keyboard input occurred.
     */
    icInput: EventEmitter<IcValueEventDetail>;
    /**
     * Emitted when a keydown event occurred.
     */
    icKeydown: EventEmitter<{
        event: KeyboardEvent;
    }>;
    connectedCallback(): void;
    disconnectedCallback(): void;
    componentWillLoad(): void;
    componentDidLoad(): void;
    handleKeyDown(ev: KeyboardEvent): void;
    /**
     * Sets focus on the native `input`.
     */
    setFocus(): Promise<void>;
    private getMaxLengthExceeded;
    private getMaxCharactersReached;
    private onInput;
    private onBlur;
    private onFocus;
    private hasStatus;
    private handleFormReset;
    private hostMutationCallback;
    render(): any;
}
