import { EventEmitter } from "../../stencil-public-runtime";
import { IcColor, IcTheme } from "../../utils/types";
export declare class Theme {
    /**
     * The theme colour. Can be a hex value e.g. "#ff0000", RGB e.g. "rgb(255, 0, 0)", or RGBA e.g. "rgba(255, 0, 0, 1)".
     */
    color?: IcColor;
    watchColorPropHandler(): void;
    /**
     * @internal Emitted when the theme is changed.
     */
    themeChange: EventEmitter<IcTheme>;
    componentWillLoad(): void;
    private checkThemeColorContrast;
    private setThemeColor;
    render(): any;
}
